package tests;

import static org.junit.jupiter.api.Assertions.assertTrue;

import association.GestionAssociation;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;


/**
 * Tests JUnit de la classe {@link association.GesionAssociation}.
 *
 * @author Lou Tinevez
 * @see association.GesionAssociation
 */
public class TestGestionAssociation {
  
  @BeforeEach
  void setUp() throws Exception {}
  
  @AfterEach
  void tearDown() throws Exception {}
  
  /**
   * Vérifie que le constructeur initialise bien les gestionnaire à null.
   */
  @Test
  void testConstructeur() {
    GestionAssociation asso = new GestionAssociation();
    assertTrue(asso.getGestionMembres() == null);
    assertTrue(asso.getGestionEvenements() == null);
  }
  
  /**
   * Vérifie que la fonction gestionnaire renvoi bien un gestionnaire non null à
   * sa première ittération, et le gestionnaire enregistré ensuite.
   * 
   */
  @Test
  void testGestionnaireEvenements() {
    GestionAssociation asso = new GestionAssociation();
    assertTrue(asso.gestionnaireEvenements() != null);
    assertTrue(asso.getGestionEvenements() == asso.gestionnaireEvenements());
  }
  
  /**
   * Vérifie que la fonction gestionnaire renvoi bien un gestionnaire non null à
   * sa première ittération, et le gestionnaire enregistré ensuite.
   * 
   */
  @Test
  void testGestionnaireMembre() {
    GestionAssociation asso = new GestionAssociation();
    assertTrue(asso.gestionnaireMembre() != null);
  }
  
  /**
   * Vérifie que l'enregistrement des données dans un fichier est réussi même si
   * le fichier n'existe pas avant la fonction.
   * 
   * @throws IOException
   * 
   */
  @Test
  void testSauvegarderDonnees() throws IOException {
    GestionAssociation asso = new GestionAssociation();
    asso.gestionnaireEvenements();
    asso.gestionnaireMembre();
    String file = "test.txt";
    asso.sauvegarderDonnees(file);
  }
  
  /**
   * Vérifie que la récupération des données depuis un fichier est réussi, les
   * données sont ensuites enregistrées dans les gestionnaires.
   * 
   * @throws IOException si le fichier n'est pas au bon format
   */
  @Test
  void testChargerDonnees() throws IOException {
    GestionAssociation asso = new GestionAssociation();
    asso.gestionnaireEvenements();
    asso.gestionnaireMembre();
    String file = "test.txt";
    asso.sauvegarderDonnees(file);
    
    GestionAssociation asso2 = new GestionAssociation();
    asso2.chargerDonnees(file);
  }
  
  /**
   * Vérifie que
   */
  
  @Test
  void testChargerDonneesWrongFile() {
    GestionAssociation asso = new GestionAssociation();
    boolean state = false;
    String file = "testnull.txt";
    try {
      asso.chargerDonnees(file);
    } catch (IOException e) {
      state = true;
      e.printStackTrace();
    }
    assertTrue(state == true);
  }
  
  
}


