package exercice1;

public class Tests {

	private static void testRegles(String nom, Evolution evo, int nbv) {
		System.out.println(nom +
				" : naitra ? " + evo.naitra(nbv) +
				" ; (false -> " + evo.etatSuivant(false, nbv) +
				") ; survivra ? " + evo.survivra(nbv) + 
				" ; (true --> " + evo.etatSuivant(true, nbv) + ")");
	}

	private static void testsRegles(int nbv) {
		System.out.println("Case entourée par " + nbv + " cellule(s) :");
		testRegles("CONWAY     ", Evolution.CONWAY, nbv);
		testRegles("DAYANDNIGHT", Evolution.DAYANDNIGHT, nbv);
		testRegles("HIGHLIFE   ", Evolution.HIGHLIFE, nbv);
		System.out.println();
	}

	public static void main(String[] args) {
		testsRegles(2);
		testsRegles(3);
		testsRegles(6);
	}

}

/*

Case entourée par 2 cellule(s) :
CONWAY      : naitra ? false ; (false -> false) ; survivra ? true ; (true --> true)
DAYANDNIGHT : naitra ? false ; (false -> false) ; survivra ? false ; (true --> false)
HIGHLIFE    : naitra ? false ; (false -> false) ; survivra ? true ; (true --> true)

Case entourée par 3 cellule(s) :
CONWAY      : naitra ? true ; (false -> true) ; survivra ? true ; (true --> true)
DAYANDNIGHT : naitra ? true ; (false -> true) ; survivra ? true ; (true --> true)
HIGHLIFE    : naitra ? true ; (false -> true) ; survivra ? true ; (true --> true)

Case entourée par 6 cellule(s) :
CONWAY      : naitra ? false ; (false -> false) ; survivra ? false ; (true --> false)
DAYANDNIGHT : naitra ? true ; (false -> true) ; survivra ? true ; (true --> true)
HIGHLIFE    : naitra ? true ; (false -> true) ; survivra ? false ; (true --> false)

*/