//
//  * tree_etu.c
//  * logMollo
//
//  * Created by Gwendal Le Tareau on 10/11/2022.
//

#include <stdio.h>
#include "tree_etu.h"
// #include <math.h>





// arbre de huffman
// struct tree_node {
    

// };





// gestion du tableau de codage des octets

// remet a zero le nombre d'occurrences des octets
void tree_resetByteOccurrence( struct byteCoding indexedCodeTable[256] )
{
    for (int i = 0 ; i < 256 ; i++)
    {
        indexedCodeTable[i].occurrence = 0;
    }
}

// remet a zero les codes octet
void tree_resetByteCoding( struct byteCoding indexedCodeTable[256] )
{
    for (int i = 0 ; i < 256 ; i++)
    {
        indexedCodeTable[i].huffmanCode = 0;
        indexedCodeTable[i].nbBits = 0;
    }
}

// compte de nombre d'occurrence des octets dans un tampon
void tree_countByteOccurrence( const t_byte * buffer, int size, struct byteCoding indexedCodeTable[256] )
{
    for (int i = 0 ; i < size ; i++)
        indexedCodeTable[buffer[i]].occurrence++;
}

// affiche la table de codage des valeurs d'octet pour debug
void tree_displayByteCoding(struct byteCoding indexedCodeTable[256])
{
    


    for (int i = 0 ; i < 256 ; i++)
    {
        printf("%d\t%d\t%d\t%d\n", indexedCodeTable[i].occurrence, indexedCodeTable[i].byte, indexedCodeTable[i].huffmanCode, indexedCodeTable[i].nbBits);
    }
}

    



/* gestion de l'arbre de Huffman */

// creation d'un noeud
struct tree_node * tree_createNode (struct tree_node * father, int * value )
{
    struct tree_node tn = {
        .parentNode = father,
        .leftChildNode = NULL,
        .rightChildNode = NULL,
        .data = value
    };
    // return &tn;
    return 0;
}

// creation d'un noeud de codage et liaison avec ses fils
struct tree_node * tree_createCodingNode ( struct tree_node * left, struct tree_node * right )
{
    
    struct tree_node *tn = (struct tree_node*) malloc(sizeof(struct tree_node));
    if (tn == NULL)
        return NULL;
    
    tn->leftChildNode = left;
    tn->rightChildNode = right;
    tn->parentNode = NULL;
    
    // int *p_data = 
    tn->data = (int *) malloc(sizeof(int));
    *(tn->data) = left->data + right->data;

    return tn;
}

// creation de l'arbre
struct tree_node * tree_create ( struct byteCoding * indexedCodeTable )
{

    // indexedCodeTable.

}

// destruction d'un arbre et liberation des donnees (sauf au niveau des feuilles)
void tree_destroy( struct tree_node * root );
    
// construit les codes de huffman en parcourant l'arbre
void tree_buildHuffmanCode(struct tree_node * root, int level, int code) ;

// affichage de l'arbre
void tree_display( struct tree_node * root, int level ) ;





int main()
{

    // int tabBinaire[8] = {128, 64, 32, 16, 8, 4, 2, 1};
    // int valDec = 134;

    // for (int i = 0 ; i < 8 ; i++)
    // {
    //     if (valDec >= tabBinaire[i])
    //     {
    //         valDec -= tabBinaire[i];
    //         tabBinaire[i] = 1;
    //         printf("1 ");
    //     }
    //     else
    //     {
    //         tabBinaire[i] = 0;
    //         printf("0 ");
    //     }
    // }

    struct byteCoding bc[256];

    tree_resetByteOccurrence(bc);
    tree_resetByteCoding(bc);


    tree_displayByteCoding(bc);


    return 0;
}