/* corrige
 * lecture du fichier des distances
 * dans une matrice carree de taille
 * lecture des coordonnées des villes dans un tableau
 * Dijkstra par rapport a un seuil
 */

#include <stdio.h>
#include <stdlib.h>


// remplissage de la matrice Distances
// de taille (TOWNS+1) * (TOWNS+1)
// pour numerotation à partir de 1
#define INFINI  99999
#define MAXDIST 300
#define TOWNS 24
int Distances[TOWNS+1][TOWNS+1];

struct {
	char name[128];
	double lat, lon;
} Gps[100];

void readDistances (char *filename)
{
	int i, j, k;
	int distance;
	FILE *fp = fopen(filename, "r");

	if (!fp) exit(-1);

	for (j=1; j<=TOWNS; j++) {
		Distances[j][j] = 0;
		for (i=1; i<j; i++) {
			int v;
			fscanf(fp, "%d", &v);
			Distances[j][i] = Distances[i][j] = (v < MAXDIST) ? v : INFINI ;
			
		}
	}
	fclose(fp);
}

void readTowns(char *filename)
{
	FILE *fp = fopen(filename, "r");
	int i;

	if (!fp) exit(-1);
	for (i=1; i<=TOWNS; i++) 
		fscanf(fp, "%s%lf%lf", Gps[i].name, &(Gps[i].lat), &(Gps[i].lon));
	fclose(fp);
}

void dijkstraTowns(int som0, int D[TOWNS+1], int C[TOWNS+1]) 
{
	/* E est un tableau de nbSommets. 
	 * E[i] == 0 si i n'est pas encore inclus dans E,
	 * E[i] == 1 sinon
	 *
	 * D t un tableau de nbSommets.
	 * a la fin de l'algorithme, D[i] vaut la distance
	 * minimale de s0 a s
	 * C est le tableau des predecesseurs
	 */
	int som, succ, poids;
	int somMini, mini;
	int E[TOWNS+1];

	/* initialisation */
	for (som=1; som<=TOWNS; som++) {
		D[som] = INFINI;
		C[som] = som0;
		E[som] = 0;
	}
	D[som0] = 0;

	// premier minimum
	somMini = som0; 
	mini = 0; 
	while (somMini != -1) { // il existe un sommet a fixer

		/* inclusion de somMini dans E */
		E[somMini] = 1;
		/* mise a jour des sommets adjacents a somMini */
		for (succ=1; succ <= TOWNS; succ++) {
			if (succ == somMini) continue;
			poids = Distances[somMini][succ];;

			if (D[succ] > D[somMini] + poids) {
				D[succ] = D[somMini] + poids;
				C[succ] = somMini;
			}
		}

		/* choix du minimum suivant */
		somMini = -1; 
		mini = INFINI; 
		for (som=1; som<=TOWNS; som++)
			if (E[som]==0 && D[som]<mini) {
				somMini = som;
				mini = D[som];
			}
	} // while
}

// a l'envers, mais pas d'importance
void printPath(char *filename, int t1, int t2, int C[TOWNS+1])
{
	FILE *fp = fopen(filename, "w");

	int t = t2;
	do {
		fprintf(fp, "%s %lf %lf\n", Gps[t].name, Gps[t].lat, Gps[t].lon);
		t = C[t];
	} while (t != t1);
	fprintf(fp, "%s %lf %lf\n", Gps[t1].name, Gps[t1].lat, Gps[t1].lon);
	
	fclose(fp);
}

void printGraph(char *filename)
{
	int i, j;
	FILE *fp = fopen(filename, "w");
	for (j=1; j<=TOWNS; j++) 
		for (i=1; i<j; i++) 
			if (Distances[i][j] < INFINI) {
				fprintf(fp, "%s %lf %lf\n", Gps[i].name, Gps[i].lat, Gps[i].lon);
				fprintf(fp, "%s %lf %lf\n", Gps[j].name, Gps[j].lat, Gps[j].lon);
				fprintf(fp, "\n");				
			}
	fclose(fp);
}


// tests
main() {
	int som, dep = 3 /* Brest */, arr = 17 /* Nice */;
	int D[TOWNS+1];
	int C[TOWNS+1];

	readDistances("distances.dat");
	readTowns("villes.dat");

 	// test de l'algorithme de Dijkstra
	dijkstraTowns(dep, D, C);
	printf("distance totale : %d\n", D[arr]);

	printPath("trajet.dat", dep /* Brest */, arr /* Nice */, C);
	printGraph("aretes.dat");

	system("gnuplot plot.script");
	system("gnuplot plotGraph.script");
	printf(" visionnez:\n eog graph.gif &; eog dijkstra.gif &\n");


}

