#include <stdio.h>
#define MAXBITRATES 1024
#define PLUS_INF 99999

int Bitrates[MAXBITRATES];

int readBitrates(char *fname)
{
	FILE *fp = fopen(fname, "r");
	int v, n = 0;

	while (fscanf(fp, "%d", &v) == 1) {
		Bitrates[n++] = v;
	}
	return n;
}

int costInterval(int i, int j)
{
	int k, cost;

	// max 
	int max = Bitrates[i];
	for(k=i+1; k<j; k++)
		if (Bitrates[k]>max) max = Bitrates[k];

	// cost = sum (max - bi)
	cost = 0;
	for(k=i; k<j; k++)
		cost += max - Bitrates[k];
	return cost;
}

int bellmanCost(int n, int period)
{
	int i, j, D[n+1];
	D[0] = 0;
	for(i=1; i<period; i++)
		D[i] = PLUS_INF;

	// bellman
	// parcours des sommets:
	for(j=period; j<=n; j++) {
		// pour chaque sommet:	
		int first = 0; // premier predecesseur
		int last = j - period; // dernier predecesseur
		if (j==n) last = j-1;
		D[j] = PLUS_INF;
		for (i=first; i<=last; i++) {
			int v = D[i] + costInterval(i, j);
			if (v < D[j]) D[j] = v;
		}
	}

	return D[n];
}


main() {
	int n, cost;
	n = readBitrates("bbb_cif_baseline_mean");
	printf("bitrate of size %d\n", n);
	cost = bellmanCost(n, 5);
	printf("cost %d\n", cost);
}


