/*
 * dijkstra.c
 * L. Lemarchand
 * 29/02/2000
 *
 * implantation de l'algorithme de Dijkstra
 */

#include <stdio.h>
#include "graphe.h"

/*
 * algorithme de Dijkstra.
 * a completer pour le TP 1.
 *
 * retourne un tableau D (de taille graphe->nb_sommets)
 * contenant pour chaque sommet i la
 * distance minimale de i0 a i
 */

int *dijkstra(i0, graphe)
int i0;
graphe_t *graphe;
{
	/* E est un tableau de nb_sommets. 
	 * E[i] == 0 si i n'est pas encore inclus dans E,
	 * E[i] == 1 sinon
	 *
	 * D t un tableau de nb_sommets.
	 * a la fin de l'algorithme, D[i] vaut la distance
	 * minimale de i0 a i
	 */

	D = int_alloc(g->nb_sommets);
	int E[graphe->nb_sommets];
	int i;

	for (i=0; i<graphe->nb_sommets; i++) {
		D[i] = PLUS_INF;
		E[i] = 0;
	}
	D[i0] = 0;

	while (1) {

		int j, min=PLUS_INF, jmin=-1; // j t.q D[j] min et j n'est pas dans E
		// calcul de min pour trouver j
		for (j=0; j<graphe->nb_sommets; j++)
			if (D[j]<min && E[j]==0) {
				min = D[j];
				jmin = j;
			}
		
		// si aucun (min == PLUS_INF) => break;
		if (min == PLUS_INF) break;

		E[jmin] = 1;
		// m.a.j des succs de jmin
		// avec lp[j] ... lp[j+1], voir print_graphe()

		for (a=graphe->lp[jmin]; a<graphe->lp[jmin+1]; a++) {
			int succ = graphe->final[a];
			int pds = graphe->poids[a];

			if (D[jmin] + pds < D[succ]) 
				D[succ] = D[jmin] + pds;

		}
	
	}

	return D;
}

