package association;

import java.util.List;

/**
 * Dfinit les actions pour un membre d'une association qui peut participer 
 * des vnements organiss par l'association.
 *
 * @author Eric Cariou
 */
public interface InterMembre {
  /**
   * La liste des vnements auquel le membre est inscrit ou a particip.
   *
   * @return la liste des vnements du membre
   */
  List<Evenement> ensembleEvenements();

  /**
   * La liste des vnements auquel le membre est inscrit et qui n'ont pas
   * encore eu lieu.
   *
   * @return la liste des vnements  venir du memmbre
   */
  List<Evenement> ensembleEvenementsAvenir();

  /**
   * Dfinit les informations personnelles du membre.
   *
   * @param info les informations personnelles du membre
   */
  void definirInformationPersonnnelle(InformationPersonnelle info);

  /**
   * Renvoie les informations personnelles du membre.
   *
   * @return l'objet contenant les informations personnelles du membre ou
   *         <code>null</code> si elles n'ont pas t dfinies
   */
  InformationPersonnelle getInformationPersonnelle();
}
