package com.controllers;

import com.dtos.LieuDto;
import com.services.impl.LieuServiceImpl;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Controller de l'api lieux
 */
@RestController
@RequestMapping("/lieux")
public class LieuController {

    private final LieuServiceImpl lieuService;
    
    public LieuController(LieuServiceImpl lieuService) {
        this.lieuService = lieuService;
    }

    /**
     * <p>Récupère tous les lieux dans le system</p>
     * @return List<LieuDto>
     */
    @GetMapping
    public List<LieuDto> getLieu() {
        return lieuService.getAllLieu();
    }

    /**
     * Créer une nouveau lieu dans le system
     * @return LieuDto le lieux créer
     */
    @PostMapping
    public LieuDto saveLieu(final @RequestBody LieuDto lieuDto){
        return lieuService.saveLieu(lieuDto);
    }

    /**
     * Récupère un lieu basé sur son ID
     * @return LieuDto le lieux possèdant l'id
     */
    @GetMapping("/{lieuxId}")
    public LieuDto lieuDto(@PathVariable Long lieuxId){
        return lieuService.getLieuById(lieuxId);
    }

    /**
     * Mets à jour un membre basé sur son ID
     * @return LieuDto le lieux mis à jour 
     */
    @PutMapping("/{lieuxId}")
    public LieuDto updateLieuDto(@PathVariable Long lieuxId, final @RequestBody LieuDto lieuDto){
        return lieuService.updateLieu(lieuxId,lieuDto);
    }

    /**
     * Supprime un membre par sont Id
     * @return Boolean
     */
    @DeleteMapping("/{lieuxId}")
    public Boolean deleteLieux(@PathVariable Long lieuxId){
        return lieuService.deleteLieu(lieuxId);
    }

}
