package com.controllers;

import com.dtos.CommentaireDto;
import com.dtos.LieuDto;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.concurrent.CompletionException;

@RestController
@RequestMapping("/commentaire")
public class CommentaireController {

    private final RestTemplate restTemplate;

    @Value("${API.COMMENTAIRE.HOSTNAME}")
    private String hostnameApiCommentaire;

    @Value("${API.COMMENTAIRE.PORT}")
    private String portApiCommentaire;


    private String  urlCommentaire;

    public CommentaireController(){
        this.restTemplate = new RestTemplate();
    }

    @PostConstruct
    public void init() {
        this.urlCommentaire = "http://" + this.hostnameApiCommentaire + ":" + this.portApiCommentaire + "/commentaire";
    }

    @GetMapping
    public List<CommentaireDto> getAllCommentaire() {
        ResponseEntity<List<CommentaireDto>> responseEntity = restTemplate.exchange(
                this.urlCommentaire ,
                HttpMethod.GET,
                null,
                new ParameterizedTypeReference<List<CommentaireDto>>() {});

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la récupération des lieux depuis l'API commentaire");
        }
        return responseEntity.getBody();
    }

    @PostMapping
    public CommentaireDto saveCommentaire(@RequestBody CommentaireDto commentaireDto){
        ResponseEntity<CommentaireDto> responseEntity = restTemplate.postForEntity(
                this.urlCommentaire,
                commentaireDto,
                CommentaireDto.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la création d'un nouveau lieu via l'API commentaire");
        }
        return responseEntity.getBody();
    }

    @GetMapping("evenement/{evenementId}")
    public List<CommentaireDto> getAllCommentaireFromEvement(@PathVariable Long evenementId){
        ResponseEntity<List<CommentaireDto>> responseEntity = restTemplate.exchange(
                this.urlCommentaire + "/evenement/" + evenementId ,
                HttpMethod.GET,
                null,
                new ParameterizedTypeReference<List<CommentaireDto>>() {});

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la récupération des lieux depuis l'API commentaire");
        }
        return responseEntity.getBody();
    }

    @GetMapping("{commentaireId}")
    public CommentaireDto getCommentaireById(@PathVariable Long commentaireId){
        ResponseEntity<CommentaireDto> responseEntity = restTemplate.exchange(
                this.urlCommentaire+ "/" + commentaireId ,
                HttpMethod.GET,
                null,
                new ParameterizedTypeReference<CommentaireDto>() {});

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la récupération des lieux depuis l'API commentaire");
        }
        return responseEntity.getBody();
    }

    @DeleteMapping("{commentaireId}")
    public Boolean deleteCommentaireById(@PathVariable Long commentaireId){
        ResponseEntity<Boolean> responseEntity = restTemplate.exchange(
                this.urlCommentaire+"/"+commentaireId,
                HttpMethod.DELETE,
                null,
                Boolean.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la suppression du commentaire avec l'ID : " + commentaireId);
        }
        return responseEntity.getBody();
    }

    @PutMapping("{commentaireId}")
    public CommentaireDto updateCommentaire(@PathVariable Long commentaireId, @RequestBody CommentaireDto commentaireDto){
        ResponseEntity<CommentaireDto> responseEntity = restTemplate.exchange(
                this.urlCommentaire +"/"+commentaireId,
                HttpMethod.PUT,
                new HttpEntity<>(commentaireDto),
                CommentaireDto.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la création d'un nouveau lieu via l'API commentaire");
        }
        return responseEntity.getBody();
    }
}
