import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    vue(),
  ],
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url))
    }
  },
  server: {
    proxy: {
      '/lieux': {
        target: 'http://localhost:7080',
        changeOrigin: true,
        secure: false,
        rewrite: (path) => path.replace(/^\/lieux/, '')
      },
      // '/membres': {
      //   target: 'http://localhost:7082',
      //   changeOrigin: true,
      //   secure: false,
      //   ws: true,
      //   rewrite: (path) => path.replace(/^\/membres/, '')
      // }
    }
  }
})
