package com.controllers;


import com.dtos.MembreDto;
import com.services.impl.MembreServiceImpl;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/membres")
public class MembreController {
    private final MembreServiceImpl memberService;

    public MembreController(MembreServiceImpl memberService) {
        this.memberService = memberService;
    }

    /**
     * <p>Récupère tous les membre dans le system</p>
     * @return List<MemberDto>
     */
    @GetMapping
    public List<MembreDto> getMembres() {
        return memberService.getAllMembres();
    }

    /**
     * Créer un nouveau membre dans le système
     * @return MembreDto le nouveau membre
     */
    @PostMapping
    public MembreDto saveMembre(final @RequestBody MembreDto membreDto){
        return memberService.saveMembre(membreDto);
    }

    /**
     * Récupère un membre basé sur son Id
     * @return le membre possèdant l'id
     */
    @GetMapping("/{membresId}")
    public MembreDto membreDto(@PathVariable Long membresId){
        return memberService.getMembreById(membresId);
    }

    /**
     * Mets à jour un membre basé sur sont ID
     * @return le membre possèdant l'id mis à jour
     */
    @PutMapping("/{membresId}")
    public MembreDto updateMembreDto(final @RequestBody MembreDto membreDto, @PathVariable Long membresId){
        return memberService.updateMembre(membresId, membreDto);
    }

    /**
     * Supprime un membre basé sur sont ID
     * @return Boolean
     */
    @DeleteMapping("/{membresId}")
    public Boolean deleteMembre(@PathVariable Long membresId){
        return memberService.deleteMembre(membresId);
    }

}
