package com.controllers;


import com.dtos.LieuDto;
import com.dtos.MembreDto;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import java.util.List;

@RestController
@RequestMapping("/membres")
@CrossOrigin(origins = "http://localhost:8000")
public class MembreController {
    private final RestTemplate restTemplate;

    @Value("${API.MEMBRE.HOSTNAME}")
    private String hostnameApiMembre;

    @Value("${API.MEMBRE.PORT}")
    private String portApiMembre;

    private String  urlMembre;

    public MembreController() {
        this.restTemplate = new RestTemplate();
    }

    /**
     * Initialise la variable urlMembre
     */
    @PostConstruct
    public void init() {
        this.urlMembre = "http://" + this.hostnameApiMembre + ":" + this.portApiMembre + "/membres/";
    }


    /**
     * <p>Récupère tous les membre dans le system</p>
     * @return List<MemberDto>
     */
    @GetMapping
    public List<MembreDto> getMembres() {
        ResponseEntity<List<MembreDto>> responseEntity = restTemplate.exchange(
                this.urlMembre ,
                HttpMethod.GET,
                null,
                new ParameterizedTypeReference<List<MembreDto>>() {});

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la récupération des lieux depuis l'API Lieu");
        }
        return responseEntity.getBody();
    }

    /**
     * Créer un nouveau membre dans le système
     * @return MembreDto
     */
    @PostMapping
    public MembreDto saveMembre(final @RequestBody MembreDto membreDto){
        ResponseEntity<MembreDto> responseEntity = restTemplate.postForEntity(
                this.urlMembre,
                membreDto,
                MembreDto.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.CREATED) {
            throw new RuntimeException("Erreur lors de la création d'un nouveau lieu via l'API Lieu");
        }
        return responseEntity.getBody();
    }

    /**
     * Récupère un membre basé sur son Id
     * @return MembreDto
     */
    @GetMapping("/{membresId}")
    public MembreDto membreDto(@PathVariable Long membresId){
        ResponseEntity<MembreDto> responseEntity = restTemplate.exchange(
                this.urlMembre +"/"+membresId,
                HttpMethod.GET,
                null,
                new ParameterizedTypeReference<MembreDto>() {});

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la récupération des lieux depuis l'API Lieu");
        }
        return responseEntity.getBody();
    }

    /**
     * Mets à jour un membre basé sur sont ID
     * @return membreDto
     */
    @PutMapping("/{membresId}")
    public MembreDto updateMembreDto(final @RequestBody MembreDto membreDto, @PathVariable Long membresId){
        ResponseEntity<MembreDto> responseEntity = restTemplate.exchange(
                this.urlMembre +"/"+membresId,
                HttpMethod.PUT,
                new HttpEntity<>(membreDto),
                MembreDto.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la création d'un nouveau lieu via l'API Lieu");
        }
        return responseEntity.getBody();
    }

    /**
     * Supprime un membre basé sur sont ID
     * @return boolean
     */
    @DeleteMapping("/{membresId}")
    public Boolean deleteMembre(@PathVariable Long membresId){
        ResponseEntity<Boolean> responseEntity = restTemplate.exchange(
                this.urlMembre+"/"+membresId,
                HttpMethod.DELETE,
                null,
                Boolean.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la suppression du lieu avec l'ID : " + membresId);
        }
        return responseEntity.getBody();
    }

}

