package com.controllers;

import com.dtos.CommentaireDto;
import com.dtos.EvenementDto;
import com.dtos.LieuDto;
import com.dtos.MembreDto;
import jdk.jfr.Event;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.bind.annotation.CrossOrigin;

import javax.annotation.PostConstruct;
import java.util.List;


@RestController
@RequestMapping("/events")
@CrossOrigin(origins = "http://localhost:8000")
public class EvenementController {

    private final RestTemplate restTemplate;


    @Value("${API.EVENEMENT.PORT}")
    private String portApiEvenement;

    @Value("${API.EVENEMENT.HOSTNAME}")
    private String hostnameApiEvenement;

    private String  urlEvenement;

    public EvenementController(){
        this.restTemplate = new RestTemplate();
    }

    @PostConstruct
    public void init() {
        this.urlEvenement = "http://" + this.hostnameApiEvenement + ":" + this.portApiEvenement + "/events";
    }

    @GetMapping
    public List<EvenementDto> getAllEvent(){
        ResponseEntity<List<EvenementDto>> responseEntity = restTemplate.exchange(
                this.urlEvenement ,
                HttpMethod.GET,
                null,
                new ParameterizedTypeReference<List<EvenementDto>>() {});

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la récupération des lieux depuis l'API commentaire");
        }
        return responseEntity.getBody();
    }

    @PostMapping
    public EvenementDto addEvent(@RequestBody EvenementDto evenementDto){
        ResponseEntity<EvenementDto> responseEntity = restTemplate.postForEntity(
                this.urlEvenement,
                evenementDto,
                EvenementDto.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la création d'un nouveau lieu via l'API Lieu");
        }
        return responseEntity.getBody();
    }


    @GetMapping("{eventId}")
    public EvenementDto getEventById(@PathVariable int eventId){
        ResponseEntity<EvenementDto> responseEntity = restTemplate.exchange(
                this.urlEvenement +"/"+eventId,
                HttpMethod.GET,
                null,
                new ParameterizedTypeReference<EvenementDto>() {});

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la récupération des lieux depuis l'API Lieu");
        }
        return responseEntity.getBody();
    }

    @PutMapping("{eventId}")
    public CommentaireDto updateEventById(@PathVariable int eventId, @RequestBody CommentaireDto commentaireDto){
        ResponseEntity<CommentaireDto> responseEntity = restTemplate.exchange(
                this.urlEvenement +"/"+eventId,
                HttpMethod.PUT,
                new HttpEntity<>(commentaireDto),
                CommentaireDto.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la création d'un nouveau lieu via l'API Lieu");
        }
        return responseEntity.getBody();
    }

    @DeleteMapping("{eventId}")
    public Boolean deleteEventById(@PathVariable int eventId){
        ResponseEntity<Boolean> responseEntity = restTemplate.exchange(
                this.urlEvenement+"/"+eventId,
                HttpMethod.DELETE,
                null,
                Boolean.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la suppression du lieu avec l'ID : " + eventId);
        }

        return responseEntity.getBody();
    }

    @GetMapping("{eventId}/membres")
    public List<EvenementDto> getAllMembreFromEventById(@PathVariable Long eventId){
        ResponseEntity<List<EvenementDto>> responseEntity = restTemplate.exchange(
                this.urlEvenement +"/"+eventId+"/membres",
                HttpMethod.GET,
                null,
                new ParameterizedTypeReference<List<EvenementDto>>() {});

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la récupération des lieux depuis l'API Lieu");
        }
        return responseEntity.getBody();
    }

    @PutMapping("{eventId}/membres")
    public MembreDto signUpdateMembreInfoById(@PathVariable Long eventId, @RequestBody MembreDto membreDto){
        ResponseEntity<MembreDto> responseEntity = restTemplate.exchange(
                this.urlEvenement +"/"+eventId+"/membres",
                HttpMethod.PUT,
                new HttpEntity<>(membreDto),
                MembreDto.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la création d'un nouveau lieu via l'API Lieu");
        }
        return responseEntity.getBody();    }

    @PutMapping("{eventId}/location")
    public LieuDto setLocationToEventById(@PathVariable Long eventId, @RequestBody LieuDto lieuDto){
        ResponseEntity<LieuDto> responseEntity = restTemplate.exchange(
                this.urlEvenement +"/"+eventId+"/location",
                HttpMethod.PUT,
                new HttpEntity<>(lieuDto),
                LieuDto.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la création d'un nouveau lieu via l'API Lieu");
        }
        return responseEntity.getBody();
    }

    @DeleteMapping("{eventId}/location")
    public Boolean deleteLocationOfEventById(@PathVariable Long eventId){
        ResponseEntity<Boolean> responseEntity = restTemplate.exchange(
                this.urlEvenement+"/"+eventId+"/location",
                HttpMethod.DELETE,
                null,
                Boolean.class
        );

        if (responseEntity.getStatusCode() != HttpStatus.OK) {
            throw new RuntimeException("Erreur lors de la suppression du lieu avec l'ID : " + eventId);
        }

        return responseEntity.getBody();
    }
}