package tp1;

public class CharArray implements Tableau<Character> {
	
	private Character[] tab;
	private int size;
	
	
	
	public CharArray(String chaine)
	{
		this.size = chaine.length();
		this.tab = new Character[this.size];
		for (int i = 0 ; i < this.size ; i++)
		{
			this.tab[i] = chaine.charAt(i);
		}
	}
	
	

	@Override
	public int size() {
		return this.size();
	}

	@Override
	public Character get(int index) {
		this.checkIndex(index);
		return this.tab[index];
	}
	private void checkIndex(int index)
	{
		if (index >= this.size || index < 0)
			throw new IndexOutOfBoundsException();
	}


	@Override
	public void set(int index, Character c) {
		this.checkIndex(index);
		this.tab[index] = c;
		
	}

	// this.tab[i] != c
	@Override
	public int indexOf(Character c) {
		int i;
		for (i = 0 ; i<this.size  ; i++) {
			if (this.tab[i].equals(c))
				return i;
		}
		return -1;
	}
	
	
	public CharArray concat(CharArray ch2)
	{
		return new CharArray(this.toString() + ch2.toString());
		
		/*
		String chaineConcat = "";
		for (int i = 0 ; i < this.size ; i++)
		{
			chaineConcat += this.tab[i];
		}
		for (int i = 0 ; i < ch2.size() ; i++)
		{
			chaineConcat += ch2.get(i);
		}
		
		//CharArray chConcat = new CharArray(chaineConcat);
		
		return new CharArray(chaineConcat); */
	}
	@Override
	public String toString()
	{
		String chaineCA = "";
		for (int i = 0 ; i < this.size ; i++)
		{
			chaineCA += this.tab[i];
		}
		return chaineCA;
	}
	
	
	public Boolean containsSub(CharArray sub)
	{
		/*
		int indexFirstSub = this.indexOf(sub.get(0));
		int tailleSub = sub.size();
		
		int trouve = 0;
		for (int i = indexFirstSub ; i < this.size || trouve < tailleSub ; i++)
		{
			if (this.tab[i] == sub.get(i))
			{
				trouve++;
			}
			else
			{
				trouve = 0;
			}
		}
		
		if (trouve == tailleSub)
		{
			return true;
		}
		else
		{
			return false;
		}
		*/
		
		return this.toString().contains(sub.toString());
		
	}
	
	
	public CharArray trim()
	{
		/*
		String chaineInitiale = "";
		for (int i = 0 ; i < this.size ; i++)
		{
			chaineInitiale += this.tab[i];
		}
		
		// CharArray chaineFinale = new CharArray(chaineInitiale.trim());
		return new CharArray(chaineInitiale.trim());
		*/
		
		return new CharArray(this.toString().trim());
	}
	

	
}
