package velo;

import visite.Visitable;
import visite.Visiteur;

/**
 * Classe Vélo.
 *
 * @author gwendal.letareau
 *
 */
public class Velo implements Visitable {

  String modele;
  int numeroSerie;
  static int dernierNumeroSerie = 0;

  Marque marque;
  Pneu pneuAvant;
  Pneu pneuArriere;
  Batterie laBatterie;

  /**
   * Constructeurs définissant le modèle et le numéro de série.
   *
   * @param modele Modèle du vélo.
   */
  public Velo(String modele, Marque marque) {
    this.modele = modele;
    this.marque = marque;

    this.numeroSerie = ++Velo.dernierNumeroSerie;
    // Velo.dernierNumeroSerie++;
  }

  /**
   * Constructeurs définissant tous les attributs.
   *
   * @param modele Modèle du vélo.
   * @param marque Marque du vélo.
   * @param pneuAvant Pneu avant du vélo.
   * @param pneuArriere Pneu arrière du vélo.
   * @param batterie Batterie du vélo.
   */
  public Velo(String modele, Marque marque, Pneu pneuAvant, Pneu pneuArriere, Batterie batterie) {
    this(modele, marque);

    this.pneuAvant = pneuAvant;
    this.pneuArriere = pneuArriere;
    this.laBatterie = batterie;
  }

  /**
   * Constructeurs définissant tous les attributs.
   *
   * @param numSerie Numéro de série du vélo.
   * @param modele Modèle du vélo.
   * @param marque Marque du vélo.
   * @param pneuAvant Pneu avant du vélo.
   * @param pneuArriere Pneu arrière du vélo.
   * @param batterie Batterie du vélo.
   */
  public Velo(int numSerie, String modele, Marque marque, Pneu pneuAvant, Pneu pneuArriere,
      Batterie batterie) {
    this.numeroSerie = numSerie;
    this.modele = modele;
    this.marque = marque;
    this.pneuAvant = pneuAvant;
    this.pneuArriere = pneuArriere;
    this.laBatterie = batterie;
  }

  public String getModele() {
    return this.modele;
  }

  public int getNumeroSerie() {
    return this.numeroSerie;
  }

  public Marque getMarque() {
    return this.marque;
  }

  public Pneu getPneuAvant() {
    return this.pneuAvant;
  }

  public Pneu getPneuArriere() {
    return this.pneuArriere;
  }

  public Batterie getBatterie() {
    return this.laBatterie;
  }

  public void setModele(String modele) {
    this.modele = modele;
  }

  public void setMarque(Marque marque) {
    this.marque = marque;
  }

  public void setPneuAvant(Pneu pneu) {
    this.pneuAvant = pneu;
  }

  public void setPneuArriere(Pneu pneu) {
    this.pneuArriere = pneu;
  }

  public void setBatterie(Batterie batterie) {
    this.laBatterie = batterie;
  }

  @Override
  public String toString() {

    return "Vélo " + (this.marque != null ? this.marque.getMarque() : "X") + " _ "
        + (this.modele != null ? this.modele : "X") + " (" + this.numeroSerie + ")\n"
        + "\tpneu avant   : " + (this.pneuAvant == null ? "null" : this.pneuAvant.toString()) + "\n"
        + "\tpneu arrière : " + (this.pneuArriere == null ? "null" : this.pneuArriere.toString())
        + "\n" + "\tbatterie     : "
        + (this.laBatterie == null ? "null" : this.laBatterie.toString()) + "\n";
  }
  
  public String getNomVeloString() {
    return (this.marque != null ? this.marque.getMarque() : "X") + " _ "
        + (this.modele != null ? this.modele : "X") + " (" + this.numeroSerie + ")";
  }


  @Override
  public boolean equals(Object o) {
    if (this != null && o == null) {
      return false;
    }

    if (this == o) {
      return true;
    }

    if (!(o instanceof Velo)) {
      return false;
    }

    Velo velo = (Velo) o;

    return (this.numeroSerie == velo.numeroSerie && this.marque == velo.marque
        && this.modele == velo.modele && this.pneuAvant == velo.pneuAvant
        && this.pneuArriere == velo.pneuAvant && this.laBatterie == velo.laBatterie);
  }


  public void appliquer(Visiteur visiteur) {
    visiteur.agirSur(this);
  }

}
