package velo;

import visite.Visitable;
import visite.Visiteur;

/**
 * Classe Pneu.
 *
 * @author gwendal.letareau
 *
 */
public class Pneu implements Visitable {

  int largeur;
  Boolean contientTube;

  Marque marque;

  /**
   * Constructeur définissant tous les attributs de la classe.
   *
   * @param largeur Largeur du pneu.
   * @param contientTube true si le pneu contient une chambre à air, false sinon.
   * @param marque Marque du pneu.
   */
  public Pneu(int largeur, Boolean contientTube, Marque marque) {
    this.largeur = largeur;
    this.contientTube = contientTube;
    this.marque = marque;
  }

  public Pneu(Marque marque) {
	this.largeur = 0;
	this.contientTube = false;
	this.marque = marque;
  }

public int getLargeur() {
    return this.largeur;
  }

  public Boolean getContientTube() {
    return this.contientTube;
  }

  public Marque getMarque() {
    return this.marque;
  }

  public void setLargeur(int largeur) {
    this.largeur = largeur;
  }

  public void setContientTube(Boolean contient) {
    this.contientTube = contient;
  }

  public void setMarque(Marque marque) {
    this.marque = marque;
  }

  @Override
  public String toString() {
    return (this.marque != null ? this.marque.getMarque() : "X") + " | " + this.largeur + "cm | "
        + (this.contientTube ? "contient " : "ne contient pas ") + "tube";
  }

  @Override
  public boolean equals(Object o) {
    if (this != null && o == null) {
      return false;
    }

    if (this == o) {
      return true;
    }

    if (!(o instanceof Batterie)) {
      return false;
    }

    Pneu pneu = (Pneu) o;

    return (this.marque == pneu.marque && this.largeur == pneu.largeur
        && this.contientTube == pneu.contientTube && this.marque == pneu.marque);
  }


  public void appliquer(Visiteur visiteur) {
    visiteur.agirSur(this);
  }

}
