package velo;

import visite.Visitable;
import visite.Visiteur;

/**
 * Classe Batterie.
 *
 * @author gwendal.letareau
 *
 */
public class Batterie implements Visitable {

  int puissance;

  Marque marque;

  public Batterie(int puissance, Marque marque) {
    this.puissance = puissance;
    this.marque = marque;
  }

  public Batterie(Marque marque) {
	this.puissance = 0;
	this.marque = marque;
  }

public int getPuissance() {
    return this.puissance;
  }

  public Marque getMarque() {
    return this.marque;
  }

  public void setPuissance(int puissance) {
    this.puissance = puissance;
  }

  public void setMarque(Marque marque) {
    this.marque = marque;
  }

  @Override
  public String toString() {
    return (this.marque != null ? this.marque.getMarque() : "X") + " | p = " + this.puissance;
  }

  @Override
  public boolean equals(Object o) {
    if (this != null && o == null) {
      return false;
    }

    if (this == o) {
      return true;
    }

    if (!(o instanceof Batterie)) {
      return false;
    }

    Batterie batterie = (Batterie) o;

    return (this.marque == batterie.marque && this.puissance == batterie.puissance);
  }


  public void appliquer(Visiteur visiteur) {
    visiteur.agirSur(this);
  }

}
