package main;

import defaut.Factory;
import defaut.FactoryFile;
import defaut.GarageVelo;
import defaut.VerificateurVelo;
import ihm.vues.VueListeVelo;
import ihm.vues.VueVelo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import velo.Batterie;
import velo.Marque;
import velo.Pneu;
import velo.Velo;

/**
 * Classe Main.
 *
 * @author gwendal.letareau
 *
 */
public class Main {

  /**
   * Méthode main.
   *
   * @param args Arguments.
   *
   * @throws FileNotFoundException Erreur si le fichier n'existe pas ou n'est pas un fichier.
   */
  public static void main(String[] args) throws FileNotFoundException {

    // velo();

    // factory();

    // lireFichier3();

    // factoryFile();
    
    vues();

  }

  static void velo() {

    Marque velotech = new Marque("Velotech");
    Marque nimbus = new Marque("NimbusCycles");
    Marque quantum = new Marque("QuantumBikes");

    Pneu pneuAvant1 = new Pneu(25, true, velotech);
    Pneu pneuArriere1 = new Pneu(25, true, velotech);
    Batterie bat1 = new Batterie(50, nimbus);

    Pneu pneuAvant2 = new Pneu(28, true, nimbus);
    Pneu pneuArriere2 = new Pneu(28, true, nimbus);
    Batterie bat2 = new Batterie(50, quantum);

    Pneu pneuAvant3 = new Pneu(20, false, quantum);
    Pneu pneuArriere3 = new Pneu(20, false, quantum);
    Batterie bat3 = new Batterie(50, velotech);

    Velo v1 = new Velo("modele1", quantum, pneuAvant1, pneuArriere1, bat1);
    Velo v2 = new Velo("modele2", velotech, pneuAvant2, pneuArriere2, bat2);
    Velo v3 = new Velo("modele3", nimbus, pneuAvant3, pneuArriere3, bat3);

    System.out.println(v1.toString());
    System.out.println(" ");
    System.out.println(v2.toString());
    System.out.println(" ");
    System.out.println(v3.toString());

    Pneu pneuAvant4 = new Pneu(26, true, velotech);
    Pneu pneuArriere4 = new Pneu(25, true, velotech);
    Batterie bat4 = new Batterie(50, nimbus);
    Velo v4 = new Velo("modele4", velotech, pneuAvant4, pneuArriere4, bat4);

    System.out.println(" ");
    System.out.println(" ");
    System.out.println("verif v1 : " + (VerificateurVelo.verifier(v1) ? "OK" : "NOK"));
    System.out.println(" ");
    System.out.println("verif v2 : " + (VerificateurVelo.verifier(v2) ? "OK" : "NOK"));
    System.out.println(" ");
    System.out.println("verif v3 : " + (VerificateurVelo.verifier(v3) ? "OK" : "NOK"));
    System.out.println(" ");
    System.out.println("verif v4 : " + (VerificateurVelo.verifier(v4) ? "OK" : "NOK"));

  }

  static void factory() {

    Marque velotech = new Marque("Velotech");
    Marque nimbus = new Marque("NimbusCycles");
    Marque quantum = new Marque("QuantumBikes");

    Factory f1 = new Factory();

    f1.configureMarqueVelo(velotech);
    f1.configureModeleVelo("Modèle 1");

    f1.configureMarquePneu(nimbus);
    f1.configureLargeurPneu(17);
    f1.configureContientTube(true);

    f1.configureMarqueBatterie(quantum);
    f1.configurePuissanceBatterie(840);

    f1.createVelo();
    System.out.println(f1.toString());
    System.out.println(f1.nombreVelos());

    f1.configureModeleVelo("Modèle 2");
    f1.configureLargeurPneu(22);
    f1.configureContientTube(false);

    f1.createVelo();
    System.out.println(f1.toString());
    System.out.println(f1.nombreVelos());

    new Velo("m", velotech);
    new Velo("m", velotech);

    f1.createVelo();
    System.out.println(f1.toString());
    System.out.println(f1.nombreVelos());

  }

  static void lireFichier() throws FileNotFoundException {
    File fichier = new File("src/test.json");
    if (!fichier.exists() || !fichier.isFile()) {
      throw new FileNotFoundException();
    }

    try {
      FileReader fr = new FileReader(fichier);
      BufferedReader br = new BufferedReader(fr);

      String ligne;
      while ((ligne = br.readLine()) != null) {
        System.out.println(ligne);
      }
      br.close();

    } catch (Exception e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }

  /*
  static void lireFichier2() throws FileNotFoundException {

    File fichier = new File("src/test.json");

    if (!fichier.exists() || !fichier.isFile()) {
      throw new FileNotFoundException();
    }

    Path chemin = Path.of(fichier.getAbsolutePath());

    try {
      String contenu = Files.readString(chemin);
      System.out.println(contenu);


    } catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }
*/

  static void lireFichier3() {
    try {
      File xmlFile = new File("src/test.xml");

      DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
      DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
      Document doc = docBuilder.parse(xmlFile);

      doc.getDocumentElement().normalize();

      System.out.println("Élément racine :" + doc.getDocumentElement().getNodeName());

      NodeList rowNodes = doc.getElementsByTagName("row");

      for (int i = 0; i < rowNodes.getLength(); i++) {
        Node rowNode = rowNodes.item(i);

        if (rowNode.getNodeType() == Node.ELEMENT_NODE) {
          System.out.println("\nVélo " + (i + 1));

          // Récupération du modèle
          Node modeleNode = getChildNode(rowNode, "modele");
          Node marqueNode = getChildNode(rowNode, "marque");
          Node nomMarqueNode = getChildNode(marqueNode, "marque");
          System.out.println("Marque = " + nomMarqueNode.getTextContent() + ", Modèle: "
              + modeleNode.getTextContent());

          // Récupération des pneus avant
          Node pneuAvantNode = getChildNode(rowNode, "pneuAvant");
          Node largeurAvantNode = getChildNode(pneuAvantNode, "largeur");
          Node contientTubeAvantNode = getChildNode(pneuAvantNode, "contientTube");
          System.out.println("Pneu avant: Largeur = " + largeurAvantNode.getTextContent()
              + ", Contient Tube = " + contientTubeAvantNode.getTextContent());

          // Récupération des pneus arrière
          Node pneuArriereNode = getChildNode(rowNode, "pneuArriere");
          Node largeurArriereNode = getChildNode(pneuArriereNode, "largeur");
          Node contientTubeArriereNode = getChildNode(pneuArriereNode, "contientTube");
          System.out.println("Pneu arrière: Largeur = " + largeurArriereNode.getTextContent()
              + ", Contient Tube = " + contientTubeArriereNode.getTextContent());

          // Récupération de la batterie
          Node batterieNode = getChildNode(rowNode, "batterie");
          Node puissanceNode = getChildNode(batterieNode, "puissance");
          System.out.println("Batterie: Puissance = " + puissanceNode.getTextContent());


        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  private static Node getChildNode(Node parent, String nodeName) {
    NodeList nodeList = parent.getChildNodes();
    for (int i = 0; i < nodeList.getLength(); i++) {
      Node node = nodeList.item(i);
      if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals(nodeName)) {
        return node;
      }
    }
    return null;
  }

  static void factoryFile() {
    FactoryFile.creerVeloFromXml("src/test.xml");
  }

  static void vues() {
    
    // Partie du code où vous créez les instances de VueListeVelo et VueVelo
    GarageVelo garageVelo = new GarageVelo();
    garageVelo.addFromXml("src/test.xml");
    VueListeVelo vueListeVelo = new VueListeVelo(garageVelo);
    VueVelo vueVelo = new VueVelo(garageVelo.get(0));
    vueListeVelo.afficher();
    vueVelo.afficher();

    // Ajoutez VueVelo comme observateur de VueListeVelo
    vueListeVelo.ajouterObserveur(vueVelo);
    vueVelo.ajouterObserveur(vueListeVelo);
    
  }
  
}
