package ihm.vues;

import defaut.GarageVelo;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.NumberFormatter;

import velo.Velo;
import visite.Observeur;

/**
 * Classe de la vue de vélo.
 *
 * @author gwendal.letareau
 *
 */
public class VueVelo implements Observeur {

  private JFrame frame;
  private Velo velo;
  
  // VELO
  private JLabel textMarque;
  private JTextField champModele;
  private JLabel textNumSerie;
  // PNEU AVANT
  private JLabel textPneuAvantMarque;
  private JTextField champPneuAvantLargeur;
  private JCheckBox checkboxPneuAvantContientTube;
  // PNEU ARRIERE
  private JLabel textPneuArriereMarque;
  private JTextField champPneuArriereLargeur;
  private JCheckBox checkboxPneuArriereContientTube;
  // BATERIE
  private JLabel textBaterieMarque;
  private JTextField champBateriePuissance;
  
  private ArrayList<Observeur> observeurs = new ArrayList<Observeur>();
  
  
  // Ajoutez d'autres champs pour les autres informations modifiables du vélo

  public VueVelo(Velo velo) {
    this.velo = velo;
    initialiser();
  }

  private void initialiser() {
    frame = new JFrame("Détails du Vélo");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setSize(600, 400);

    JPanel panel = new JPanel(new GridLayout(0, 2));
    panel.setBorder(new EmptyBorder(10, 10, 10, 10));
    
    
    NumberFormatter format = new NumberFormatter();
    format.setValueClass(Integer.class);

    // VELO
    panel.add(new JLabel("Vélo"));
    panel.add(new JLabel());
    
    // VELO - NUM SERIE
    panel.add(new JLabel("Marque"));
    textMarque = new JLabel((velo.getMarque() != null ? velo.getMarque().getMarque() : "X"));
    panel.add(textMarque);
    
    // VELO - MODELE
    panel.add(new JLabel("Modèle"));
    champModele = new JTextField((velo.getModele() != null ? velo.getModele() : "X"));
    panel.add(champModele);

    // VELO - NUM SERIE
    panel.add(new JLabel("Numéro de série"));
    textNumSerie = new JLabel("" + velo.getNumeroSerie());
    panel.add(textNumSerie);
    
    
    
    panel.add(new JLabel());
    panel.add(new JLabel());
    
    
    
    // PNEU AVANT
    panel.add(new JLabel("Pneu avant"));
    panel.add(new JLabel());
    
    // PNEU AVANT - MARQUE
    panel.add(new JLabel("Marque"));
    textPneuAvantMarque = new JLabel((velo.getPneuAvant().getMarque() != null ? velo.getPneuAvant().getMarque().getMarque() : "X"));
    panel.add(textPneuAvantMarque);
    
    // PNEU AVANT - LARGEUR
    panel.add(new JLabel("Largeur"));
    champPneuAvantLargeur = new JTextField("" + velo.getPneuAvant().getLargeur());
    panel.add(champPneuAvantLargeur);
    
    // PNEU AVANT - CONTIENT TUBE
    panel.add(new JLabel("Conient tube"));
    checkboxPneuAvantContientTube = new JCheckBox();
    checkboxPneuAvantContientTube.setSelected(velo.getPneuAvant().getContientTube());
    panel.add(checkboxPneuAvantContientTube);
    
    
    
    panel.add(new JLabel());
    panel.add(new JLabel());
    

    
    // PNEU ARRIERE
    panel.add(new JLabel("Pneu arrière"));
    panel.add(new JLabel());
    
    // PNEU ARRIERE - MARQUE
    panel.add(new JLabel("Marque"));
    textPneuArriereMarque = new JLabel((velo.getPneuArriere().getMarque() != null ? velo.getPneuArriere().getMarque().getMarque() : "X"));
    panel.add(textPneuArriereMarque);
    
    // PNEU ARRIERE - LARGEUR
    panel.add(new JLabel("Largeur"));
    champPneuArriereLargeur = new JTextField("" + velo.getPneuArriere().getLargeur());
    panel.add(champPneuArriereLargeur);
    
    // PNEU ARRIERE - CONTIENT TUBE
    panel.add(new JLabel("Conient tube"));
    checkboxPneuArriereContientTube = new JCheckBox();
    checkboxPneuArriereContientTube.setSelected(velo.getPneuArriere().getContientTube());
    panel.add(checkboxPneuArriereContientTube);
    
    
    
    panel.add(new JLabel());
    panel.add(new JLabel());
    
    
    
    // BATERIE
    panel.add(new JLabel("Batterie"));
    panel.add(new JLabel());
    
    // BATERIE - MARQUE
    panel.add(new JLabel("Marque"));
    textBaterieMarque = new JLabel((velo.getBatterie().getMarque() != null ? velo.getBatterie().getMarque().getMarque() : "X"));
    panel.add(textBaterieMarque);
    
    // BATERIE - PUISSANCE
    panel.add(new JLabel("Puissance"));
    champBateriePuissance = new JTextField(velo.getBatterie().getPuissance());
    panel.add(champBateriePuissance);
    
    
    
    // BOUTON
    JButton sauvegarderButton = new JButton("Sauvegarder");
    sauvegarderButton.addActionListener(e -> sauvegarderModifications());
    frame.add(sauvegarderButton, BorderLayout.SOUTH);

    frame.getContentPane().add(panel);
    
    
    JTextField[] champs = {
    		champPneuAvantLargeur,
    		champPneuArriereLargeur,
    		champBateriePuissance
    };
    for (JTextField champ : champs) {
    	champ.addKeyListener(new KeyAdapter() {
            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c)) {
                    e.consume(); // Ignore non-digit characters
                }
            }
        });
    }
    
  }

  private void sauvegarderModifications() {
    velo.setModele(champModele.getText());
    
    velo.getPneuAvant().setLargeur(Integer.parseInt(champPneuAvantLargeur.getText()));
    velo.getPneuAvant().setContientTube(checkboxPneuAvantContientTube.isSelected());
    
    velo.getPneuArriere().setLargeur(Integer.parseInt(champPneuArriereLargeur.getText()));
    velo.getPneuArriere().setContientTube(checkboxPneuArriereContientTube.isSelected());
    
    velo.getBatterie().setPuissance(Integer.parseInt(champBateriePuissance.getText()));
    
    for (Observeur obs : this.observeurs) {
      obs.mettreAjour(null);
    }
    System.out.println("Modifications sauvegardées : " + velo);
    // frame.dispose();
  }

  public void afficher() {
    frame.setVisible(true);
  }

  /**
   * Fonction main de la vue.
   *
   * @param args Arguments de la fonction main.
   */
  public static void main(String[] args) {
    GarageVelo garageVelo = new GarageVelo();
    garageVelo.addFromXml("src/test.xml");
    
    VueVelo vueVelo = new VueVelo(garageVelo.get(1));
    vueVelo.afficher();
  }

  
  public void ajouterObserveur(Observeur obs) {
    this.observeurs.add(obs);
  }
  
  @Override
  public void mettreAjour(Velo velo) {
	  
	if (velo != null) {
		
		this.velo = velo;
		// VELO
		textMarque.setText((velo.getMarque() != null ? velo.getMarque().getMarque() : "X"));
    	champModele.setText((velo.getModele() != null ? velo.getModele() : "X"));
    	textNumSerie.setText("" + velo.getNumeroSerie());
    	// PNEU AVANT
    	textPneuAvantMarque.setText((velo.getPneuAvant().getMarque() != null ? velo.getPneuAvant().getMarque().getMarque() : "X"));
    	champPneuAvantLargeur.setText("" + velo.getPneuAvant().getLargeur());
    	checkboxPneuAvantContientTube.setSelected(velo.getPneuAvant().getContientTube());
    	// PNEU ARRIERE
    	textPneuArriereMarque.setText((velo.getPneuArriere().getMarque() != null ? velo.getPneuArriere().getMarque().getMarque() : "X"));
    	champPneuArriereLargeur.setText("" + velo.getPneuArriere().getLargeur());
    	checkboxPneuArriereContientTube.setSelected(velo.getPneuArriere().getContientTube());
    	// BATERIE
    	textBaterieMarque.setText((velo.getBatterie().getMarque() != null ? velo.getBatterie().getMarque().getMarque() : "X"));
    	champBateriePuissance.setText("" + velo.getBatterie().getPuissance());
	}
	else {
		textMarque.setText("");
    	champModele.setText("");
    	textNumSerie.setText("");
    	// PNEU AVANT
    	textPneuAvantMarque.setText("");
    	champPneuAvantLargeur.setText("");
    	checkboxPneuAvantContientTube.setSelected(false);
    	// PNEU ARRIERE
    	textPneuArriereMarque.setText("");
    	champPneuArriereLargeur.setText("");
    	checkboxPneuArriereContientTube.setSelected(false);
    	// BATERIE
    	textBaterieMarque.setText("");
    	champBateriePuissance.setText("");
	}
    
  }
  
  
}
