package ihm.vues;

import defaut.GarageVelo;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

import velo.Batterie;
import velo.Marque;
import velo.Pneu;
import velo.Velo;
import visite.Observeur;

/**
 * Classe de la vue de la liste des vélos.
 *
 * @author gwendal.letareau
 */
public class VueListeVelo implements Observeur {

  private JFrame frame;
  private JList<String> listeVeloView;
  private GarageVelo garageVelo;
  private HashMap<String, Velo> lesVelos;
  private ArrayList<Observeur> observeurs = new ArrayList<Observeur>();

  /**
   * Constructeur de la vue.
   *
   * @param garageVelo Garage à partir duquel initialiser la liste.
   */
  public VueListeVelo(GarageVelo garageVelo) {
    this.garageVelo = garageVelo;
    this.lesVelos = getNomsVelos(garageVelo.getVelos());
    initialiser();
  }

  private void initialiser() {
    frame = new JFrame("Liste des Vélos");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setSize(500, 300);
    
    listeVeloView = new JList<>((String[]) this.lesVelos.keySet().toArray(new String[0]));
    listeVeloView.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    listeVeloView.addMouseListener(new MouseAdapter() {
      @Override
      public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
          afficherDetails();
        }
      }
    });

    JPanel panel = new JPanel(new BorderLayout());
    JScrollPane scrollPane = new JScrollPane(listeVeloView);
    panel.add(scrollPane, BorderLayout.CENTER);

    JButton afficherDetailsButton = new JButton("Afficher");
    afficherDetailsButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        afficherDetails();
      }
    });
    
    
    JButton creerVeloButton = new JButton("Créer");
    creerVeloButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        creerVelo();
      }
    });
    
    
    JButton supprimerVeloButton = new JButton("Supprimer");
    supprimerVeloButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        supprimerVelo();
      }
    });
    
    JPanel boutonsPanel = new JPanel(new FlowLayout());
    boutonsPanel.add(afficherDetailsButton);
    boutonsPanel.add(creerVeloButton);
    boutonsPanel.add(supprimerVeloButton);
    panel.add(boutonsPanel, BorderLayout.SOUTH);
    

    frame.getContentPane().add(panel);
  }

  private HashMap<String, Velo> getNomsVelos(ArrayList<Velo> velos) {
    HashMap<String, Velo> map = new HashMap<String, Velo>();
    for (Velo velo : velos) {
      map.put(velo.getNomVeloString(), velo);
    }
    
    return map;
  }

  private void afficherDetails() {
    for (Observeur obs : this.observeurs) {
      String veloSelectionne = listeVeloView.getSelectedValue();
      obs.mettreAjour(this.lesVelos.get(veloSelectionne));
    }
  }
  private void creerVelo() {
	  Velo velo = new Velo("", new Marque(""), new Pneu(new Marque("")), new Pneu(new Marque("")), new Batterie(new Marque("")));
	  this.garageVelo.add(velo);
	  this.mettreAjour(null);
	  listeVeloView.setSelectedValue(velo.getNomVeloString(), true);
	  for (Observeur obs : this.observeurs) {
	      obs.mettreAjour(this.lesVelos.get(velo.getNomVeloString()));
	  }
  }
  private void supprimerVelo() {
	  if (!listeVeloView.isSelectionEmpty()) {
		  this.garageVelo.remove(this.lesVelos.get(listeVeloView.getSelectedValue()));
		  this.mettreAjour(null);
		  for (Observeur obs : this.observeurs) {
		      obs.mettreAjour(null);
		  }
	  }
  }

  public void afficher() {
    frame.setVisible(true);
  }
  
  
  
  public void ajouterObserveur(Observeur obs) {
    this.observeurs.add(obs);
  }


  /**
   * Fonction main de la classe.
   *
   * @param args Arguments de main.
   */
  public static void main(String[] args) {
    // Créer un GarageVelo (vous pouvez charger des données depuis un fichier XML ici)
    GarageVelo garageVelo = new GarageVelo();
    garageVelo.addFromXml("src/test.xml");
    System.out.println(garageVelo.size());

    // Créer une instance de VueListeVelo en lui passant le GarageVelo
    VueListeVelo vueListeVelo = new VueListeVelo(garageVelo);

    // Afficher la fenêtre Swing
    vueListeVelo.afficher();
  }

  @Override
  public void mettreAjour(Velo velo) {
    this.lesVelos = getNomsVelos(this.garageVelo.getVelos());

    listeVeloView.setListData(this.lesVelos.keySet().toArray(new String[0]));

    listeVeloView.repaint();
  }
}
