package defaut;

import velo.Velo;

/**
 * Classe vérifiant qu'un vélo possède deux roues de même marque, de même type et de même largeur,
 * la largeur étant comprise entre 19 et 30 (inclus).
 *
 * @author gwendal.letareau
 *
 */
public abstract class VerificateurVelo {

  static final int LARGEUR_MIN = 19;
  static final int LARGEUR_MAX = 30;

  /**
   * Retourne un booléen indiquant si le vélo correspond aux critères demandés.
   *
   * @return true si le vélo correspond aux critères demandés, false sinon.
   */
  public static Boolean verifier(Velo velo) {
    return (velo.getPneuAvant() != null && velo.getPneuArriere() != null
        && velo.getPneuAvant().getMarque() == velo.getPneuArriere().getMarque()
        && velo.getPneuAvant().getLargeur() == velo.getPneuArriere().getLargeur()
        && velo.getPneuAvant().getLargeur() >= VerificateurVelo.LARGEUR_MIN
        && velo.getPneuAvant().getLargeur() <= VerificateurVelo.LARGEUR_MAX);
  }

}
