package defaut;

import java.util.ArrayList;
import java.util.Collection;
import velo.Batterie;
import velo.Pneu;
import velo.Velo;

/**
 * Classe GarageVelo.
 *
 * @author gwendal.letareau
 */
public class GarageVelo {

  private ArrayList<Velo> lesVelos;


  public GarageVelo() {
    this.lesVelos = new ArrayList<Velo>();
  }


  public void addFromXml(String fichier) {
    this.lesVelos.addAll(FactoryFile.creerVeloFromXml(fichier));
  }

  
  public ArrayList<Velo> getVelos() {
    return this.lesVelos;
  }

  public Velo get(int index) {
    return this.lesVelos.get(index);
  }

  public void add(int index, Velo velo) {
    this.lesVelos.add(index, velo);
  }

  public void add(Velo velo) {
    this.lesVelos.add(velo);
  }

  public void addAll(int index, Collection<Velo> velos) {
    this.lesVelos.addAll(index, lesVelos);
  }

  public void addAll(Collection<Velo> velos) {
    this.lesVelos.addAll(lesVelos);
  }

  public void remove(int index) {
    this.lesVelos.remove(index);
  }

  public void remove(Velo velo) {
    this.lesVelos.remove(velo);
  }

  public void set(int index, Velo velo) {
    this.lesVelos.set(index, velo);
  }

  public Boolean contains(Velo velo) {
    return this.lesVelos.contains(velo);
  }

  public int size() {
    return this.lesVelos.size();
  }

  public Boolean isEmpty() {
    return this.lesVelos.isEmpty();
  }

  public int indexOf(Velo velo) {
    return this.lesVelos.indexOf(velo);
  }

  public int lastIndexOf(Velo velo) {
    return this.lesVelos.lastIndexOf(velo);
  }


  public Pneu getPneuAvant(int index) {
    return this.lesVelos.get(index).getPneuAvant();
  }

  /**
   * Renvoi le pneu avant du vélo.
   *
   * @param velo Velo pour lequel récupérer le penu avant.
   * @return Retourne le pneu avant s'il existe, null sinon.
   */
  public Pneu getPneuAvant(Velo velo) {
    if (!this.contains(velo)) {
      return null;
    }
    return velo.getPneuAvant();
  }

  public Pneu getPneuArriere(int index) {
    return this.lesVelos.get(index).getPneuArriere();
  }

  /**
   * Renvoi le pneu arrière du vélo.
   *
   * @param velo Velo pour lequel récupérer le penu arrière.
   * @return Retourne le pneu arrière s'il existe, null sinon.
   */
  public Pneu getPneuArriere(Velo velo) {
    if (!this.contains(velo)) {
      return null;
    }
    return velo.getPneuArriere();
  }

  public Batterie getBatterie(int index) {
    return this.lesVelos.get(index).getBatterie();
  }

  /**
   * Renvoi la batterie du vélo.
   *
   * @param velo Velo pour lequel récupérer la batterie.
   * @return Retourne la batterie si elle existe, null sinon.
   */
  public Batterie getBatterie(Velo velo) {
    if (!this.contains(velo)) {
      return null;
    }
    return velo.getBatterie();
  }


  public void setPneuAvant(int index, Pneu pneu) {
    this.lesVelos.get(index).setPneuAvant(pneu);
  }

  /**
   * Modifie le pneu avant du vélo.
   *
   * @param velo Velo pour lequel modifier le penu avant.
   * @param pneu Pneu à attribuer comme pneu avant du vélo.
   */
  public void setPneuAvant(Velo velo, Pneu pneu) {
    if (this.contains(velo)) {
      velo.setPneuAvant(pneu);
    }
  }

  public void setPneuArriere(int index, Pneu pneu) {
    this.lesVelos.get(index).setPneuArriere(pneu);
  }

  /**
   * Modifie le pneu arrière du vélo.
   *
   * @param velo Velo pour lequel modifier le penu arrière.
   * @param pneu Pneu à attribuer comme pneu arrière du vélo.
   */
  public void setPneuArriere(Velo velo, Pneu pneu) {
    if (this.contains(velo)) {
      velo.setPneuArriere(pneu);
    }
  }

  public void setBatterie(int index, Batterie batterie) {
    this.lesVelos.get(index).setBatterie(batterie);
  }

  /**
   * Modifie la batterie du vélo.
   *
   * @param velo Velo pour lequel modifier la batterie.
   * @param batterie Batterie à attribuer au vélo.
   */
  public void setBatterie(Velo velo, Batterie batterie) {
    if (this.contains(velo)) {
      velo.setBatterie(batterie);
    }
  }


}
