package defaut;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import velo.Batterie;
import velo.Marque;
import velo.Pneu;
import velo.Velo;

/**
 * Factory créant les vélos contenus dans un fichier XML
 * en vérifiant l'unicité des numéros de série.
 *
 * @author gwendal.letareau
 *
 */
public class FactoryFile {


  /**
   * Fonction de création des vélos dont les caractéristiques sont contenus dans un fichier XML.
   *
   * @param cheminFichier Chemin du fichier XML dans lequel les vélos sont contenu.
   * @return Liste de vélos créés.
   */
  public static ArrayList<Velo> creerVeloFromXml(String cheminFichier) {
    try {
      File xmlFile = new File(cheminFichier);

      if (!xmlFile.exists() || !xmlFile.isFile()) {
        throw new FileNotFoundException();
      }

      DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
      DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
      Document doc = docBuilder.parse(xmlFile);

      doc.getDocumentElement().normalize();


      ArrayList<Velo> lesVelos = new ArrayList<Velo>();
      ArrayList<Integer> listeNumerosSerie = new ArrayList<Integer>();
      NodeList rowNodes = doc.getElementsByTagName("row");

      for (int i = 0; i < rowNodes.getLength(); i++) {
        Node rowNode = rowNodes.item(i);

        if (rowNode.getNodeType() == Node.ELEMENT_NODE) {

          // Récupération du modèle
          int numeroSerie =
              Integer.parseInt((getChildNode(rowNode, "numeroSerie").getTextContent()));
          if (!listeNumerosSerie.contains(numeroSerie)) {


            String modele = getChildNode(rowNode, "modele").getTextContent();
            Node marqueNodeVelo = getChildNode(rowNode, "marque");
            String nomMarqueVelo = getChildNode(marqueNodeVelo, "marque").getTextContent();


            // Récupération du pneu avant
            Node pneuAvantNode = getChildNode(rowNode, "pneuAvant");

            int largeurAvant =
                Integer.parseInt(getChildNode(pneuAvantNode, "largeur").getTextContent());

            Boolean contientTubeAvant =
                Boolean.parseBoolean(getChildNode(pneuAvantNode, "contientTube").getTextContent());

            Node marqueNodePneuAvant = getChildNode(pneuAvantNode, "marque");
            String nomMarquePneuAvant =
                getChildNode(marqueNodePneuAvant, "marque").getTextContent();


            // Récupération du pneu arrière
            Node pneuArriereNode = getChildNode(rowNode, "pneuArriere");

            int largeurArriere =
                Integer.parseInt(getChildNode(pneuArriereNode, "largeur").getTextContent());

            Boolean contientTubeArriere = Boolean
                .parseBoolean(getChildNode(pneuArriereNode, "contientTube").getTextContent());

            Node marqueNodePneuArriere = getChildNode(pneuArriereNode, "marque");
            String nomMarquePneuArriere =
                getChildNode(marqueNodePneuArriere, "marque").getTextContent();


            // Récupération de la batterie
            Node batterieNode = getChildNode(rowNode, "batterie");

            int puissance =
                Integer.parseInt(getChildNode(batterieNode, "puissance").getTextContent());

            Node marqueNodeBatterie = getChildNode(batterieNode, "marque");
            String nomMarqueBatterie = getChildNode(marqueNodeBatterie, "marque").getTextContent();



            Velo velo = new Velo(numeroSerie, modele, new Marque(nomMarqueVelo),
                new Pneu(largeurAvant, contientTubeAvant, new Marque(nomMarquePneuAvant)),
                new Pneu(largeurArriere, contientTubeArriere, new Marque(nomMarquePneuArriere)),
                new Batterie(puissance, new Marque(nomMarqueBatterie)));

            lesVelos.add(velo);

            System.out.println(velo);

          }

        }

      }

      return lesVelos;

    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;

  }


  private static Node getChildNode(Node parent, String nodeName) {
    NodeList nodeList = parent.getChildNodes();
    for (int i = 0; i < nodeList.getLength(); i++) {
      Node node = nodeList.item(i);
      if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals(nodeName)) {
        return node;
      }
    }
    return null;
  }
}
