package defaut;

import java.util.ArrayList;
import java.util.List;
import velo.Batterie;
import velo.Marque;
import velo.Pneu;
import velo.Velo;

/**
 * Factory.
 *
 * @author gwendal.letareau
 *
 */
public class Factory {

  Marque marqueVelo;
  String modeleVelo;

  Marque marquePneu;
  int largeurPneu;
  Boolean contientTube;

  Marque marqueBatterie;
  int puissanceBatterie;


  List<Velo> lesVelos;


  public Factory() {
    this.modeleVelo = "";
    this.lesVelos = new ArrayList<Velo>();
  }

  /**
   * Crée tous les composants du vélo puis le vélo avec les composants précédents et l'ajoute à la
   * liste.
   */
  public void createVelo() {
    Pneu pneuAvant = new Pneu(largeurPneu, contientTube, marquePneu);
    Pneu pneuArriere = new Pneu(largeurPneu, contientTube, marquePneu);
    Batterie batterie = new Batterie(puissanceBatterie, marqueBatterie);
    Velo velo = new Velo(modeleVelo, marqueVelo, pneuAvant, pneuArriere, batterie);
    this.lesVelos.add(velo);
  }

  public Marque getMarqueVelo() {
    return marqueVelo;
  }

  public void configureMarqueVelo(Marque marqueVelo) {
    this.marqueVelo = marqueVelo;
  }


  public String getModeleVelo() {
    return modeleVelo;
  }

  public void configureModeleVelo(String modeleVelo) {
    this.modeleVelo = modeleVelo;
  }


  public Marque getMarquePneu() {
    return marquePneu;
  }

  public void configureMarquePneu(Marque marquePneu) {
    this.marquePneu = marquePneu;
  }


  public int getLargeurPneu() {
    return largeurPneu;
  }

  public void configureLargeurPneu(int largeurPneu) {
    this.largeurPneu = largeurPneu;
  }


  public Boolean getContientTube() {
    return contientTube;
  }

  public void configureContientTube(Boolean contientTube) {
    this.contientTube = contientTube;
  }


  public Marque getMarqueBatterie() {
    return marqueBatterie;
  }

  public void configureMarqueBatterie(Marque marqueBatterie) {
    this.marqueBatterie = marqueBatterie;
  }


  public int getPuissanceBatterie() {
    return puissanceBatterie;
  }

  public void configurePuissanceBatterie(int puissanceBatterie) {
    this.puissanceBatterie = puissanceBatterie;
  }


  public List<Velo> getVelos() {
    return lesVelos;
  }

  public int nombreVelos() {
    return this.lesVelos.size();
  }


  @Override
  public String toString() {
    String res = "";
    for (Velo v : this.lesVelos) {
      res += v.toString() + "\n";
    }
    return res;
  }

}
