package defaut;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import velo.Velo;

/**
 * Décodeur Json.
 *
 * @author gwendal.letareau
 */
public abstract class DecoderJson {

  /**
   * Décode un fichier XML.
   *
   * @param fichier Fichier à décoder.
   * @return Liste des vélos contenus dans le fichier.
   * @throws FileNotFoundException Erreur retournée si le fichier n'existe pas
   *        ou n'est pas un fichier.
   */
  public static List<Velo> decoderXmlFromFile(File fichier) throws FileNotFoundException {

    try {
      File xmlFile = new File("chemin/vers/votre/fichier.xml");

      DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
      DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
      Document doc = docBuilder.parse(xmlFile);

      doc.getDocumentElement().normalize();

      System.out.println("Élément racine :" + doc.getDocumentElement().getNodeName());

      NodeList nodeList = doc.getElementsByTagName("votre_tag");

      for (int temp = 0; temp < nodeList.getLength(); temp++) {
        Node node = nodeList.item(temp);

        if (node.getNodeType() == Node.ELEMENT_NODE) {
          System.out.println("\nÉlément :" + node.getNodeName());
          System.out.println("Contenu :" + node.getTextContent());
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }



    return null;
  }

  public static List<Velo> decoderJsonFromString(String fichier) {
    return null;
  }

}
