#include "ens.h"

void ensNouv(ens_t *e)
{
	e->nb = 0;
}

int ensIns(ens_t *e, int val) 
{
	if (ensNb(e) == MAXENS) 
		return 0;
	e->donnees[e->nb] = val;
	e->nb++;
	return 1;
}

// retourne l’index de la premiere occurence de val dans // e (-1 si absent)
int ensTrouve(ens_t *e, int val)
{
	int i;
	for(i=0; i<e->nb; i++) 
		if (e->donnees[i] == val) return i;
	return -1;
}

// supprime la premiere occurence de val dans e (renvoie // son index, et -1 si absent)
int ensSuppr(ens_t *e, int val)
{
	int i = ensTrouve(e, val);
	if (i == -1) return -1;
	e->nb -= 1; 
	if (ensNb(e) == 0) { 
		return 0; 
	}
	e->donnees[i] = e->donnees[e->nb];
	return i;
}


// supprime toutes les occurences de val dans e (renvoie // le nombre d’occurences supprimees)
int ensSupprTous(ens_t *e, int val)
{
	int nboccs = 0;
	while (ensSuppr(e, val) >= 0)
		nboccs++;
	return nboccs;
}

void ensAff(ens_t *e)
{
	int i;
	for(i=0; i<e->nb; i++)
		printf("%d ", e->donnees[i]);
	printf("\n");
}


/* main() dans main.c
 * {
 * 	ens_t e1;
 * 	ensNouv(&e1);
 * 	ensIns(&e1, 12);
 * 	ensIns(&e1, 2);
 * 	...
 * 	ensAffiche(&e1);
 * }
 */
