// ens.c
#include <stdio.h>
#include "ens.h"

void ensNouv(ens_t *e) {        // initialise un nouvel ensemble
	e->nb = 0;
}

int ensIns(ens_t *e, int val) {    // insere val dans l’ensemble
	if (e->nb < MAXENS) {
		e->donnees[e->nb] = val;
		(e->nb)++;
		return 1;
	}
	else
		return 0;
}

int ensTrouve(ens_t *e, int val) {   // retourne l’index de la premiere occurence de val dans
				     // e (-1 si absent)

	int i;

	for (i=0; i<e->nb; i++)
		if (e->donnees[i] == val) 
			return i;
	return -1;
}

int ensSuppr(ens_t *e, int val) {     // supprime la premiere occurence de val dans e (renvoie
				     // son index, et -1 si absent)
	int i, idx = ensTrouve(e, val);
	if (idx == -1) return -1;
	e->nb--;
	for(i=idx; i<e->nb; i++)
		e->donnees[i] = e->donnees[i+1];
	return idx;
}

int ensSupprTous(ens_t *e, int val) { // supprime toutes les occurences de val dans e (renvoie
				      // le nombre d’occurences supprimees)
	int nb = 0;
	while (ensSuppr(e, val) != -1) 
		nb++;
	return nb;
}


int ensSupprTousMieux(ens_t *e, int val) { // supprime toutes les occurences de val dans e (renvoie
				      // le nombre d’occurences supprimees)
	int lu, copie;
	copie = 0;
	for (lu=0; lu<e->nb; lu++) {
		if (e->donnees[lu] != val) {
			e->donnees[copie] = e->donnees[lu];
			copie++;
		}
	}
	e->nb = copie;
	return lu - copie;
}
void ensReset(ens_t *e) {           // reset e à vide.
	e->nb = 0;
}
void ensAff(ens_t *e)  {              // affiche le contenu d’un ensemble sur la sortie standard
	                             // quelques fonctionalites supplementaires
	                             // implantees sous forme de macros
	int i;
	
	printf("[ ");
	for (i=0; i<e->nb; i++)
		printf("%d ", e->donnees[i]);
	printf("]\n");

}
