// ens.c

// le nombre d’elements alloues a chaque augmentation de la taille des donnees
#include "tp3correns.h"

ens_t *ensNouv()
{
	enst_t *e = (ens_t *)malloc(sizeof(ens_t));
	if (!e) return NULL;
	e->donnees = (int *)malloc(BLOC*sizeof(int));
	if (!e->donnees) return NULL;
	e->alloues = BLOC;
	e->nb = 0;
	return e;
}

void ensIns(ens_t *e, int val)
{
	if (e->nb == e->alloues) {
		e->alloues += BLOC;
		e->donnees = (int *)realloc(e->donnees, e->alloues*sizeof(int));
		if (!e->donnees) { perror("alloc mem"); exit(0); }
	}
	e->donnees[nb] = val;
	nb++;
}

int ensTrouve(ens_t *e, int val)
{
	int i;
	
	for(i=0; i<e->nb; i++) 
		if (e->donnees[i] == val) return i;
	return -1;
}

int ensSuppr(ens_t *e, int val)
{
	int idx = ensTrouve(e, val);
	int i;

	if (idx == -1) 
		return -1;
	for(i=idx; i<e->nb-1; i++) 
		e->donnees[i] = e->donnees[i+1];
	e->nb--;
	return idx;
}
int ensSupprTous(ens_t *e, int val)
{
	int occurences = 0;
	while (ensSuppr(e, val) != -1) 
		occurences++;
	return occurences;
}
				     
void ensLibere(ens_t *e)
{
	free(e->donnees);
	free(e);
}

void ensAff(ens_t *e)
{
	int i;

	for(i=0; i<e->nb; i++)
		printf("%d ", e->donnees[i]);
	printf("\n");
}

#define ensContient(e, val) (ensTrouve(e, val) != -1 ? 1 : 0) // vrai si val present dans e
#define ensNb(e) (e->nb)             // taille de e
#define ensVide(e) (ensNb(e) == 0 ? 1 : 0) // vrai si e vide
#define ensInsUnique(e, val) (ensContient(e, val) ? 0 : (ensIns(e, val), 1)) /* insere val dans e sans
					                                        doublon. renvoie vrai
					                                        si insertion faite
					                                        faux si val presente */



