-- MySQL Script generated by MySQL Workbench
-- Thu Jan 19 10:19:49 2023
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema zdl3-zle_targw_1
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Schema zdl3-zle_targw_1
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `zdl3-zle_targw_1` DEFAULT CHARACTER SET utf8 ;
USE `zdl3-zle_targw_1` ;

-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_compte_cpt`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_compte_cpt` (
  `cpt_pseudo` VARCHAR(50) NOT NULL,
  `cpt_mdp` CHAR(64) NOT NULL,
  `cpt_nom` VARCHAR(80) NOT NULL,
  `cpt_prenom` VARCHAR(80) NOT NULL,
  `cpt_etat` CHAR(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cpt_pseudo`))
ENGINE = InnoDB;

INSERT INTO `zdl3-zle_targw_1`.`t_compte_cpt` (cpt_pseudo, cpt_mdp, cpt_nom, cpt_prenom, cpt_etat) VALUES 
  ('j.dupont', '4sD7mKjL1', 'Dupont', 'Jacques', 'A'), 
  ('f.martin', '2cF8nLkM2', 'Martin', 'François', 'A'), 
  ('c.leroy', '3dG9oMlN3', 'Leroy', 'Céline', 'A'), 
  ('a.david', '1aB6jIgH0', 'David', 'Anne', 'A'), 
  ('b.garcia', '2bC7kJhI1', 'Garcia', 'Bruno', 'A'), 
  ('e.petit', '5eF0nKjL4', 'Petit', 'Emilie', 'A'), 
  ('d.roux', '4dE9mJkL3', 'Roux', 'Damien', 'A'), 
  ('g.vergne', '7gH2oMnN6', 'Vergne', 'Guillaume', 'A'), 
  ('h.bertrand', '8hI3pNoO7', 'Bertrand', 'Hélène', 'A'), 
  ('i.carpentier', '9iJ4qOpP8', 'Carpentier', 'Isabelle', 'A');

-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_compte_org`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_compte_org` (
  `cpt_pseudo` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`cpt_pseudo`),
  CONSTRAINT `fk_compte_org_compte`
    FOREIGN KEY (`cpt_pseudo`)
    REFERENCES `zdl3-zle_targw_1`.`t_compte_cpt` (`cpt_pseudo`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO `zdle-zle_targw_1`.`t_compte_org` VALUES("j.dupont"), ("f.martin");


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_actualite_act`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_actualite_act` (
  `act_idActualite` INT NOT NULL AUTO_INCREMENT,
  `act_message` VARCHAR(500) NOT NULL,
  `org_cpt_pseudo` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`act_idActualite`),
  INDEX `fk_actualite_compte_org1_idx` (`org_cpt_pseudo` ASC),
  CONSTRAINT `fk_actualite_compte_org1`
    FOREIGN KEY (`org_cpt_pseudo`)
    REFERENCES `zdl3-zle_targw_1`.`t_compte_org` (`cpt_pseudo`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO `zdl3-zle_targw_1`.`t_actualite_act` (act_message, org_cpt_pseudo) VALUES
  ('La compétition d\'escalade aura lieu les 5 et 6 juin prochains. Inscrivez-vous dès maintenant !', 'j.dupont'),
  ('Nous avons le plaisir de vous annoncer la participation de plusieurs champions internationaux à notre compétition.', 'f.martin'),
  ('La règlementation de la compétition a été mise à jour. Merci de la consulter avant de vous inscrire.', 'j.dupont'),
  ('Des ateliers d\'entraînement seront proposés les 3 et 4 juin pour les participants.', 'f.martin'),
  ('L\'inscription à la compétition est ouverte jusqu\'au 30 avril.', 'j.dupont'),
  ('Des prix seront remis aux meilleurs grimpeurs de chaque catégorie.', 'f.martin'),
  ('La compétition se déroulera dans la salle d\'escalade de Grenoble.', 'j.dupont');

-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_compte_jury`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_compte_jury` (
  `jury_discipline` VARCHAR(30) NOT NULL,
  `jury_url` VARCHAR(300) NOT NULL,
  `jury_bio` VARCHAR(500) NOT NULL,
  `cpt_pseudo` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`cpt_pseudo`),
  CONSTRAINT `fk_compte_jury_compte1`
    FOREIGN KEY (`cpt_pseudo`)
    REFERENCES `zdl3-zle_targw_1`.`t_compte_cpt` (`cpt_pseudo`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO `zdl3-zle_targw_1`.`t_compte_jury` (jury_discipline, jury_url, jury_bio, cpt_pseudo) VALUES
  ('Difficulté', 'http://www.cleroy.com', 'Céline Leroy est une grimpeuse passionnée et un membre actif de plusieurs clubs.', 'c.leroy'),
  ('Difficulté', 'http://www.adavid.com', 'Anne David est une grimpeuse expérimentée et un entraîneur certifié.', 'a.david'),
  ('Vitesse', 'http://www.bgarcia.com', 'Bruno Garcia est un grimpeur passionné et un membre actif de plusieurs clubs.', 'b.garcia'),
  ('Bloc', 'http://www.epetit.com', 'Emilie Petit est une grimpeuse compétitive et un membre actif de plusieurs clubs.', 'e.petit'),
  ('Difficulté', 'http://www.droux.com', 'Damien Roux est un grimpeur passionné et un membre actif de plusieurs clubs.', 'd.roux'),
  ('Bloc', 'http://www.gvergne.com', 'Guillaume Vergne est un grimpeur passionné et un membre actif de plusieurs clubs.', 'g.vergne'),
  ('Bloc', 'http://www.hbertrand.com', 'Hélène Bertrand est une grimpeuse passionnée et un membre actif de plusieurs clubs.', 'h.bertrand'),
  ('Vitesse', 'http://www.icarpentier.com', 'Isabelle Carpentier est une grimpeuse expérimentée et un membre actif de plusieurs clubs.', 'i.carpentier');

-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_concours_conc`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_concours_conc` (
  `conc_idConcours` INT NOT NULL AUTO_INCREMENT,
  `conc_nomConcours` VARCHAR(50) NOT NULL,
  `conc_date` DATE NOT NULL,
  `conc_description` VARCHAR(200) NOT NULL,
  `org_cpt_pseudo` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`conc_idConcours`),
  INDEX `fk_concours_compte_org1_idx` (`org_cpt_pseudo` ASC),
  CONSTRAINT `fk_concours_compte_org1`
    FOREIGN KEY (`org_cpt_pseudo`)
    REFERENCES `zdl3-zle_targw_1`.`t_compte_org` (`cpt_pseudo`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO `zdl3-zle_targw_1`.`t_concours_conc` (conc_nomConcours, conc_date, conc_description, org_cpt_pseudo) VALUES
  ('Grenoble Open', '2024-08-01', 'Compétition internationale d\'escalade organisée à Grenoble', 'j.dupont'),
  ('Championnat de France', '2024-07-01', 'Rassemblement des meilleurs grimpeurs français', 'f.martin'),
  ('Coupe de l\'Isère', '2024-06-15', 'Compétition régionale ouverte à tous les grimpeurs', 'j.dupont'),
  ('Bloc Party', '2024-09-01', 'Compétition de blocs organisée par les étudiants de l\'Université Grenoble Alpes', 'f.martin'),
  ('Grenoble Bouldering', '2024-05-01', 'Compétition de blocs en extérieur dans les alentours de Grenoble', 'j.dupont'),
  ('Vertical Race', '2024-04-01', 'Compétition de vitesse organisée sur un mur d\'escalade extérieur', 'f.martin'),
  ('Grenoble Masters', '2024-03-01', 'Compétition réservée aux grimpeurs de plus de 40 ans', 'j.dupont');
  
-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_categorie_cat`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_categorie_cat` (
  `cat_idCategorie` INT NOT NULL AUTO_INCREMENT,
  `cat_nomCategorie` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`cat_idCategorie`))
ENGINE = InnoDB;

INSERT INTO `zdl3-zle_targw_1`.`t_categorie_cat` (cat_nomCategorie) VALUES
01  ('U14 difficulté homme'),
02  ('U14 difficulté femme'),
03  ('U14 vitesse homme'),
04  ('U14 vitesse femme'),
05  ('U14 bloc homme'),
06  ('U14 bloc femme'),
07  ('U16 difficulté homme'),
08  ('U16 difficulté femme'),
09  ('U16 vitesse homme'),
10  ('U16 vitesse femme'),
11  ('U16 bloc homme'),
12  ('U16 bloc femme'),
13  ('U18 difficulté homme'),
14  ('U18 difficulté femme'),
15  ('U18 vitesse homme'),
16  ('U18 vitesse femme'),
17  ('U18 bloc homme'),
18  ('U18 bloc femme'),
19  ('U20 difficulté homme'),
20  ('U20 difficulté femme'),
21  ('U20 vitesse homme'),
22  ('U20 vitesse femme'),
23  ('U20 bloc homme'),
24  ('U20 bloc femme'),
25  ('Sénior difficulté homme'),
26  ('Sénior difficulté femme'),
27  ('Sénior vitesse homme'),
28  ('Sénior vitesse femme'),
29  ('Sénior bloc homme'),
30  ('Sénior bloc femme'),
31  ('Vétéran difficulté homme'),
32  ('Vétéran difficulté femme'),
33  ('Vétéran vitesse homme'),
34  ('Vétéran vitesse femme'),
35  ('Vétéran bloc homme'),
36 ('Vétéran bloc femme');

-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_possede_poss`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_possede_poss` (
  `idConcours` INT NOT NULL,
  `idCategorie` INT NOT NULL,
  PRIMARY KEY (`idConcours`, `idCategorie`),
  INDEX `fk_concours_has_categorie_categorie1_idx` (`idCategorie` ASC),
  INDEX `fk_concours_has_categorie_concours1_idx` (`idConcours` ASC),
  CONSTRAINT `fk_concours_has_categorie_concours1`
    FOREIGN KEY (`idConcours`)
    REFERENCES `zdl3-zle_targw_1`.`t_concours_conc` (`conc_idConcours`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_concours_has_categorie_categorie1`
    FOREIGN KEY (`idCategorie`)
    REFERENCES `zdl3-zle_targw_1`.`t_categorie_cat` (`cat_idCategorie`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;
INSERT INTO `zdl3-zle_targw_1`.`t_possede_poss` (idConcours, idCategorie) VALUES
  (1, 1), (1, 2), (1, 3), (1, 4), (1, 5), (1, 6), (1, 7), (1, 8), (1, 9), (1, 10), (1, 11), (1, 12), (1, 13), (1, 14), (1, 15), (1, 16), (1, 17), (1, 18),
  (1, 19), (1, 20), (1, 21), (1, 22), (1, 23), (1, 24), (1, 25), (1, 26), (1, 27), (1, 28), (1, 29), (1, 30), (1, 31), (1, 32), (1, 33), (1, 34), (1, 35), (1, 36),
  
  (2, 1), (2, 2), (2, 3), (2, 4), (2, 5), (2, 6), (2, 7), (2, 8), (2, 9), (2, 10), (2, 11), (2, 12), (2, 13), (2, 14), (2, 15), (2, 16), (2, 17), (2, 18),
  (2, 19), (2, 20), (2, 21), (2, 22), (2, 23), (2, 24), (2, 25), (2, 26), (2, 27), (2, 28), (2, 29), (2, 30), (2, 31), (2, 32), (2, 33), (2, 34), (2, 35), (2, 36),
  
  (3, 1), (3, 2), (3, 3), (3, 4), (3, 5), (3, 6), (3, 7), (3, 8), (3, 9), (3, 10), (3, 11), (3, 12), (3, 13), (3, 14), (3, 15), (3, 16), (3, 17), (3, 18),
  (3, 19), (3, 20), (3, 21), (3, 22), (3, 23), (3, 24), (3, 25), (3, 26), (3, 27), (3, 28), (3, 29), (3, 30), (3, 31), (3, 32), (3, 33), (3, 34), (3, 35), (3, 36),
  
  (4, 1), (4, 2), (4, 3), (4, 4), (4, 5), (4, 6), (4, 7), (4, 8), (4, 9), (4, 10), (4, 11), (4, 12), (4, 13), (4, 14), (4, 15), (4, 16), (4, 17), (4, 18),
  (4, 19), (4, 20), (4, 21), (4, 22), (4, 23), (4, 24), (4, 25), (4, 26), (4, 27), (4, 28), (4, 29), (4, 30), (4, 31), (4, 32), (4, 33), (4, 34), (4, 35), (4, 36),
  
  (5, 1), (5, 2), (5, 3), (5, 4), (5, 5), (5, 6), (5, 7), (5, 8), (5, 9), (5, 10), (5, 11), (5, 12), (5, 13), (5, 14), (5, 15), (5, 16), (5, 17), (5, 18),
  (5, 19), (5, 20), (5, 21), (5, 22), (5, 23), (5, 24), (5, 25), (5, 26), (5, 27), (5, 28), (5, 29), (5, 30), (5, 31), (5, 32), (5, 33), (5, 34), (5, 35), (5, 36),
  
  (6, 1), (6, 2), (6, 3), (6, 4), (6, 5), (6, 6), (6, 7), (6, 8), (6, 9), (6, 10), (6, 11), (6, 12), (6, 13), (6, 14), (6, 15), (6, 16), (6, 17), (6, 18),
  (6, 19), (6, 20), (6, 21), (6, 22), (6, 23), (6, 24), (6, 25), (6, 26), (6, 27), (6, 28), (6, 29), (6, 30), (6, 31), (6, 32), (6, 33), (6, 34), (6, 35), (6, 36),
  
  (7, 1), (7, 2), (7, 3), (7, 4), (7, 5), (7, 6), (7, 7), (7, 8), (7, 9), (7, 10), (7, 11), (7, 12), (7, 13), (7, 14), (7, 15), (7, 16), (7, 17), (7, 18),
  (7, 19), (7, 20), (7, 21), (7, 22), (7, 23), (7, 24), (7, 25), (7, 26), (7, 27), (7, 28), (7, 29), (7, 30), (7, 31), (7, 32), (7, 33), (7, 34), (7, 35), (7, 36);



-- -----------------------------------------------------



-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_fil_fil`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_fil_fil` (
  `fil_idFil` INT NOT NULL AUTO_INCREMENT,
  `fil_titre` VARCHAR(50) NOT NULL,
  `fil_description` VARCHAR(200) NOT NULL,
  `conc_idConcours` INT NOT NULL,
  PRIMARY KEY (`fil_idFil`),
  INDEX `fk_fil_concours1_idx` (`conc_idConcours` ASC),
  CONSTRAINT `fk_fil_concours1`
    FOREIGN KEY (`conc_idConcours`)
    REFERENCES `zdl3-zle_targw_1`.`t_concours_conc` (`conc_idConcours`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO zdl3-zle_targw_1.t_fil_fil (fil_titre, fil_description, conc_idConcours) VALUES
  ('Discussion sur le concours U14 difficulté homme', 'Ce fil de discussion est dédié au concours de difficulté U14 pour les hommes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 1),
  ('Discussion sur le concours U14 vitesse homme', 'Ce fil de discussion est dédié au concours de vitesse U14 pour les hommes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 2),
  ('Discussion sur le concours U14 bloc homme', 'Ce fil de discussion est dédié au concours de bloc U14 pour les hommes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 3),
  ('Discussion sur le concours U14 difficulté femme', 'Ce fil de discussion est dédié au concours de difficulté U14 pour les femmes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 4),
  ('Discussion sur le concours U14 vitesse femme', 'Ce fil de discussion est dédié au concours de vitesse U14 pour les femmes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 5),
  ('Discussion sur le concours U14 bloc femme', 'Ce fil de discussion est dédié au concours de bloc U14 pour les femmes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 6),
  ('Discussion sur le concours U16 difficulté homme', 'Ce fil de discussion est dédié au concours de difficulté U16 pour les hommes. Les membres du jury peuvent discuter des performances des candidats et partager leur avis.', 7);

-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_message_msg`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_message_msg` (
  `idMessage` INT NOT NULL AUTO_INCREMENT,
  `texte` VARCHAR(500) NOT NULL,
  `date` DATE NULL,
  `fil_idFil` INT NOT NULL,
  `jury_cpt_pseudo` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`idMessage`),
  INDEX `fk_message_fil1_idx` (`fil_idFil` ASC),
  INDEX `fk_message_compte_jury1_idx` (`jury_cpt_pseudo` ASC),
  CONSTRAINT `fk_message_fil1`
    FOREIGN KEY (`fil_idFil`)
    REFERENCES `zdl3-zle_targw_1`.`t_fil_fil` (`fil_idFil`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_message_compte_jury1`
    FOREIGN KEY (`jury_cpt_pseudo`)
    REFERENCES `zdl3-zle_targw_1`.`t_compte_jury` (`cpt_pseudo`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO `zdl3-zle_targw_1`.`t_message_msg` (texte, date, fil_idFil, jury_cpt_pseudo) VALUES 
  ("Je suis impressionné par les performances des candidats de la catégorie U14 difficulté", "2022-05-01", 1, "c.leroy"), 
  ("Je suis d'accord, ils ont tous un très bon niveau technique", "2022-05-02", 1, "a.david"), 
  ("Il y a un candidat en particulier qui m'a vraiment marqué, il a un potentiel incroyable", "2022-05-03", 1, "b.garcia"), 
  ("Je suis d'accord avec vous, il est vraiment prometteur", "2022-05-04", 1, "e.petit"), 
  ("Je pense qu'il mérite une mention spéciale", "2022-05-05", 1, "d.roux"), 
  ("On devrait l'encourager à poursuivre dans cette voie", "2022-05-06", 1, "g.vergne"), 
  ("Je suis d'accord, il a vraiment un avenir prometteur dans l'escalade", "2022-05-07", 1, "h.bertrand"), 
  ("Je vais noter cela dans mes commentaires", "2022-05-08", 1, "i.carpentier"),
  
  ('Bonjour, je voulais discuter des performances des candidats U14 en difficulté', '2022-12-01', 2, 'c.leroy'),
  ('Salut, je suis d\'accord avec toi. J\'ai remarqué que certains manquaient de technique', '2022-12-02', 2, 'a.david'),
  ('Oui, c\'est vrai. Peut-être qu\'il faudrait les entraîner davantage avant le concours', '2022-12-03', 2, 'b.garcia'),
  
  ('Bonjour, je voulais discuter des performances des candidats U16 en vitesse', '2022-12-04', 3, 'e.petit'),
  ('Salut, je suis d\'accord avec toi. J\'ai remarqué que certains manquaient de rapidité', '2022-12-05', 3, 'd.roux'),
  ('Oui, c\'est vrai. Peut-être qu\'il faudrait les entraîner davantage avant le concours', '2022-12-06', 3, 'g.vergne'),
  
  ("Bonjour, je suis intéressé par les performances des candidats U14 en difficulté.", "2022-12-01", 4, "c.leroy"),
  ("Je suis d'accord, il y a beaucoup de potentiel chez cette catégorie.", "2022-12-02", 4, "a.david"),
  ("Je suis également intéressé par les performances des candidats U14 en vitesse.", "2022-12-03", 4, "b.garcia"),
  ("Il y a des progrès à faire pour les candidats U14 en bloc.", "2022-12-04", 4, "e.petit"),
  ("J'aimerais discuter des résultats des candidates U14 en difficulté.", "2022-12-05", 4, "d.roux"),
  ("Je suis d'accord, il faut continuer à suivre les performances de cette catégorie.", "2022-12-06", 4, "g.vergne"),
  ("Il y a des talents prometteurs chez les U14, il faut continuer à les encourager.", "2022-12-07", 4, "h.bertrand"),
  ("Je suis d'accord, il faut continuer à suivre les performances de cette catégorie.", "2022-12-08", 4, "i.carpentier"),
  
  ('Bonjour, je me suis inscrit au concours n°5, je suis prêt pour la compétition !', '2022-01-01', 5, 'c.leroy'),
  ('Bienvenue ! Nous sommes impatients de voir ce que tu as à nous montrer.', '2022-01-02', 5, 'a.david'),
  ('Merci beaucoup ! Je vais tout donner.', '2022-01-03', 5, 'c.leroy'),
  
  ('Bonjour, je viens de regarder les performances des candidats dans la catégorie U20 difficulté et je suis impressionné par leur niveau.', '2022-05-06', 6, 'c.leroy'),
  ('Je suis d\'accord avec toi c.leroy, il y a vraiment de très bons grimpeurs.', '2022-05-06', 6, 'a.david'),
  ('Il faut vraiment être vigilant pour faire les bons choix.', '2022-05-07', 6, 'b.garcia'),
  ('Je suis d\'accord, il y a vraiment beaucoup de talents cette année.', '2022-05-07', 6, 'e.petit'),
  
  ('La progression des candidats est intéressante à suivre.', '2022-08-01', '7', 'c.leroy'),
  ('Je suis d\'accord, ils ont tous un bon niveau.', '2022-08-02', '7', 'a.david'),
  ('Il y a deux ou trois candidats qui sortent du lot.', '2022-08-03', '7', 'b.garcia'),
  ('Oui, il faudra les surveiller de près.', '2022-08-04', '7', 'e.petit'),
  ('Il y a des candidats qui sont très techniques.', '2022-08-05', '7', 'd.roux'),
  ('Il y a des candidats qui sont très rapides.', '2022-08-06', '7', 'g.vergne'),
  ('Il y a des candidats qui sont très forts en bloc.', '2022-08-07', '7', 'h.bertrand'),
  ('Il faudra prendre en compte tous ces aspects pour évaluer les candidats.', '2022-08-08', '7', 'i.carpentier');

-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_participant_part`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_participant_part` (
  `part_mail` VARCHAR(300) NOT NULL,
  `part_codeInscription` CHAR(20) NOT NULL,
  `part_codeIdentifiant` CHAR(8) NOT NULL,
  `part_nom` VARCHAR(80) NOT NULL,
  `part_prenom` VARCHAR(80) NOT NULL,
  `cat_idCategorie` INT NOT NULL,
  PRIMARY KEY (`part_mail`),
  INDEX `fk_participant_categorie1_idx` (`cat_idCategorie` ASC),
  CONSTRAINT `fk_participant_categorie1`
    FOREIGN KEY (`cat_idCategorie`)
    REFERENCES `zdl3-zle_targw_1`.`t_categorie_cat` (`cat_idCategorie`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO t_participant_part (part_mail, part_codeInscription, part_codeIdentifiant, part_nom, part_prenom, cat_idCategorie) VALUES 
  ('paul.dupont@gmail.com', 'sjhq3g4f2j8hq3g4', 'q3g4f2j8', 'Dupont', 'Paul', 27),
  ('emilie.leblanc@gmail.com', '5bv1j9c8hq3g4f2', 'bv1j9c8', 'Leblanc', 'Emilie', 10),
  ('raphael.bernard@gmail.com', 'j9c8hq3g4f2j8hq', '9c8hq3g4', 'Bernard', 'Raphael', 1),
  ('lucas.durand@gmail.com', 'hq3g4f2j8hq3g4f', 'hq3g4f2', 'Durand', 'Lucas', 27),
  ('marie.robert@gmail.com', 'j8hq3g4f2j8hq3g', '8hq3g4f2', 'Robert', 'Marie', 26),
  ('julien.petit@gmail.com', 'f2j8hq3g4f2j8hq', '2j8hq3g4', 'Petit', 'Julien', 19),
  ('chloe.dufour@gmail.com', 'q3g4f2j8hq3g4f2', 'q3g4f2j', 'Dufour', 'Chloe', 10),
  
  ('j.francois@example.com', 'yutrvwqzgsjzpxnj', 'xmzpyvjn', 'Francois', 'Julien', 29),
  ('b.durand@example.com', 'qzsjvwqrzgjzpxnj', 'zpyvjnxs', 'Durand', 'Bruno', 9),
  ('g.leclerc@example.com', 'zpqzsjvwqrzgjzpx', 'njzpyvjnxs', 'Leclerc', 'Gabriel', 9),
  ('e.dupont@example.com', 'qzsjvwqrzgjzpxnj', 'zpyvjnxs', 'Dupont', 'Eric', 21),
  ('s.martin@example.com', 'zpqzsjvwqrzgjzpx', 'njzpyvjnxs', 'Martin', 'Sophie', 2),
  
  ('lea.barnier@gmail.com', 'jk8f6g4j6k7g6j2d', 'k3s8g5j6', 'Barnier', 'Léa', 22),
  ('maxime.duval@gmail.com', 'z8x7c6v5b4n3m2', 'q3w8e5', 'Duval', 'Maxime', 33),
  ('emilie.lefebvre@gmail.com', 'n7m6l5k4j3h2g1', 'a1s2d3', 'Lefebvre', 'Emilie', 26),
  ('paul.lemoine@gmail.com', 'k4j3h2g1f6d5c4', 'z1x2c3', 'Lemoine', 'Paul', 11),
  ('lucie.martin@gmail.com', 'g1f6d5c4b3n2m1', 'q1w2e3', 'Martin', 'Lucie', 4),
  
  ('b.le-gall@gmail.com', 'hqxq5oyej5h5w5g5z5', 'y5gy5z5w5', 'Le Gall', 'Bastien', 9),
  ('e.le-cunff@gmail.com', 'n8e5k5i5v5h5p5c5n8', 's5c5v5k5', 'Le Cunff', 'Erwan', 1),
  ('f.le-flem@gmail.com', 'g6c5o5d5e5r5v5g6', 'w5o5d5c5', 'Le Flem', 'Fred', 11);

-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_document_doc`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_document_doc` (
  `doc_idDocument` INT NOT NULL AUTO_INCREMENT,
  `doc_chemin` VARCHAR(200) NOT NULL,
  `doc_type` VARCHAR(45) NOT NULL,
  `part_mail` VARCHAR(300) NOT NULL,
  PRIMARY KEY (`doc_idDocument`),
  INDEX `fk_document_participant1_idx` (`part_mail` ASC),
  CONSTRAINT `fk_document_participant1`
    FOREIGN KEY (`part_mail`)
    REFERENCES `zdl3-zle_targw_1`.`t_participant_part` (`part_mail`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO t_document_doc (doc_chemin, doc_type, part_mail) VALUES ('c:\users\documents\fichier_jean_dupont.pdf', 'pdf', 'jean.dupont@mail.com');
  ('https://drive.google.com/file/d/123abc', 'pdf', 'paul.durand@mail.com'),
  ('c:\users\documents\fichier_lucie_bertrand.pdf', 'pdf', 'lucie.bertrand@mail.com'),
  ('https://drive.google.com/file/d/456def', 'pdf', 'marc.olivier@mail.com'),
  ('c:\users\documents\fichier_sophie_martin.pdf', 'pdf', 'sophie.martin@mail.com'),
  ('https://drive.google.com/file/d/789ghi', 'pdf', 'julien.dupont@mail.com'),
  ('c:\users\documents\fichier_julie_robert.pdf', 'pdf', 'julie.robert@mail.com'),
  ('https://drive.google.com/file/d/abc123', 'pdf', 'pierre.henry@mail.com'),
  ('c:\users\documents\fichier_mathilde_bernard.pdf', 'pdf', 'mathilde.bernard@mail.com'),
  ('https://drive.google.com/file/d/def456', 'pdf', 'claire.lucas@mail.com'),
  ('c:\users\documents\fichier_antoine_meunier.pdf', 'pdf', 'antoine.meunier@mail.com'),
  ('https://drive.google.com/file/d/ghi789', 'pdf', 'lucas.duval@mail.com');

-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_note_note`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_note_note` (
  `jury_cpt_pseudo` VARCHAR(50) NOT NULL,
  `part_mail` VARCHAR(300) NOT NULL,
  `note_note` DECIMAL(10,2) NOT NULL,
  PRIMARY KEY (`jury_cpt_pseudo`, `part_mail`),
  INDEX `fk_compte_jury_has_participant_participant1_idx` (`part_mail` ASC),
  INDEX `fk_compte_jury_has_participant_compte_jury1_idx` (`jury_cpt_pseudo` ASC),
  CONSTRAINT `fk_compte_jury_has_participant_compte_jury1`
    FOREIGN KEY (`jury_cpt_pseudo`)
    REFERENCES `zdl3-zle_targw_1`.`t_compte_jury` (`cpt_pseudo`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_compte_jury_has_participant_participant1`
    FOREIGN KEY (`part_mail`)
    REFERENCES `zdl3-zle_targw_1`.`t_participant_part` (`part_mail`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO zdl3-zle_targw_1.t_note_note (jury_cpt_pseudo, part_mail, note_note) VALUES
  ('c.leroy', 'antoine.dufour@gmail.com', 7.20),
  ('c.leroy', 'florent.durand@gmail.com', 8.40),
  ('c.leroy', 'lucas.lefebvre@gmail.com', 6.90),
  ('a.david', 'antoine.dufour@gmail.com', 8.50),
  ('a.david', 'florent.durand@gmail.com', 9.00),
  ('a.david', 'lucas.lefebvre@gmail.com', 8.00);


-- -----------------------------------------------------


-- -----------------------------------------------------
-- Table `zdl3-zle_targw_1`.`t_siege_siege`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `zdl3-zle_targw_1`.`t_siege_siege` (
  `conc_idConcours` INT NOT NULL,
  `jury_cpt_pseudo` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`conc_idConcours`, `jury_cpt_pseudo`),
  INDEX `fk_concours_has_compte_jury_compte_jury1_idx` (`jury_cpt_pseudo` ASC),
  INDEX `fk_concours_has_compte_jury_concours1_idx` (`conc_idConcours` ASC),
  CONSTRAINT `fk_concours_has_compte_jury_concours1`
    FOREIGN KEY (`conc_idConcours`)
    REFERENCES `zdl3-zle_targw_1`.`t_concours_conc` (`conc_idConcours`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_concours_has_compte_jury_compte_jury1`
    FOREIGN KEY (`jury_cpt_pseudo`)
    REFERENCES `zdl3-zle_targw_1`.`t_compte_jury` (`cpt_pseudo`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

INSERT INTO `zdl3-zle_targw_1`.`t_siege_siege` (`conc_idConcours`, `jury_cpt_pseudo`) VALUES 
  (1, 'c.leroy'),
  (1, 'a.david'),
  (1, 'b.garcia'),
  
  (2, 'c.leroy'),
  (2, 'e.petit'),
  (2, 'd.roux'),
  
  (3, 'a.david'),
  (3, 'b.garcia'),
  (3, 'd.roux'),
  
  (4, 'g.vergne'),
  (4, 'c.leroy'),
  (4, 'a.david'),
  (4, 'b.garcia'),
  (4, 'e.petit'),
  
  (5, 'd.roux'),
  (5, 'g.vergne'),
  (5, 'h.bertrand'),
  (5, 'i.carpentier'),
  
  (6, 'c.leroy'),
  (6, 'c.leroy'),
  (6, 'a.david'),
  (6, 'b.garcia'),
  (6, 'e.petit'),
  (6, 'd.roux'),
  
  (7, 'g.vergne'),
  (7, 'h.bertrand'),
  (7, 'i.carpentier'),
  (7, 'c.leroy');


-- -----------------------------------------------------


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;






