// #include <unistd.h>
// #include <stdio.h>

// int main() {
//     char hostname[1024];
//     gethostname(hostname, sizeof hostname);
//     printf("Hostname: %s\n", hostname);
//     return 0;
// }




// #include <stdio.h>
// #include <netdb.h>
// #include <arpa/inet.h>

// int main() {
//     struct hostent *host;
//     char hostname[1024];
//     gethostname(hostname, sizeof hostname);
//     host = gethostbyname(hostname);
//     printf("IP address: %u\n", *(unsigned int *) host->h_addr);
//     return 0;
// }



// #include <stdio.h>
// #include <netdb.h>
// #include <arpa/inet.h>

// int main(int argc, char *argv[]) {
//     struct hostent *host;
//     if (argc != 2) {
//         printf("Usage: %s hostname\n", argv[0]);
//         return 1;
//     }
//     host = gethostbyname(argv[1]);
//     if (host == NULL) {
//         printf("Error: Unable to resolve hostname\n");
//         return 1;
//     }
//     printf("IP address: %s\n", inet_ntoa(*(struct in_addr *) host->h_addr));
//     return 0;
// }




#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#define BUFSIZE 1024

int main(int argc, char *argv[]) {
    int src, dest, n;
    char buf[BUFSIZE];

    if (argc != 3) {
        printf("Usage: %s source_file destination_file\n", argv[0]);
        return 1;
    }

    src = open(argv[1], O_RDONLY);
    if (src == -1) {
        perror("Error opening source file");
        return 1;
    }

    dest = open(argv[2], O_WRONLY | O_CREAT | O_TRUNC, 0644);
    if (dest == -1) {
        perror("Error opening destination file");
        close(src);
        return 1;
    }

    while ((n = read(src, buf, BUFSIZE)) > 0) {
        if (write(dest, buf, n) != n) {
            perror("Error writing to destination file");
            close(src);
            close(dest);
            return 1;
        }
    }

    if (n == -1) {
        perror("Error reading from source file");
        close(src);
        close(dest);
        return 1;
    }

    close(src);
    close(dest);
    return 0;
}
