package exercice3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import exercice1.Cpg;

/**
 * Convertiseur de fichier.
 * 
 * <p>
 * Un convertisseur permet soit de crypter, soit de décrypter un fichier.
 */
abstract class Convertisseur implements Runnable {

	/**
	 * Nom du fichier à convertir.
	 */
	protected String fichier;

	/**
	 * Contenu du fichier à convertir.
	 */
	protected List<Integer> contenu;

	/**
	 * Crypteur utilisé pour crypter ou décrypter le fichier.
	 */
	protected Cpg crypteur;

	/**
	 * Indique si le fichier a déjà été converti.
	 */
	protected boolean converti;

	/**
	 * Constructeur.
	 * 
	 * @param fichier nom du fichier à convertir
	 */
	public Convertisseur(String fichier) {
		this.fichier  = fichier;
		this.contenu  = new ArrayList<>();
		this.crypteur = null;
		this.converti = false;
	}

	/**
	 * Démarre la conversion sur un fil d'exécution concurrent.
	 * 
	 * <p>
	 * La conversion démarre seulement si le fichier n'a pas déjà été converti.
	 * 
	 * @return fil d'exécution qui exécute la conversion, ou null si le fichier a
	 *         déjà été converti
	 */
	public Thread start() {
		if (this.converti) return null;
		this.converti = true;

		// TODO à compléter...
		return null; // <- TODO à mettre à jour
	}

	/**
	 * Charge le fichier à convertir.
	 * 
	 * @return indique si le chargement est interrompu
	 * @throws IOException soulevée quand le fichier n'est pas accessible
	 */
	protected boolean load() throws IOException {
		// TODO à compléter...
		return false; // <- TODO à mettre à jour
	}

	/**
	 * Converti et sauvegarde le fichier à convertir.
	 * 
	 * @param crypte indique si la conversion correspond au cryptage du fichier
	 * @return indique si la conversion est interrompue
	 * @throws IOException soulevée quand le fichier n'est pas accessible
	 */
	protected boolean convertAndSave(boolean crypte) throws IOException {
		// TODO à compléter...
		return false; // <- TODO à mettre à jour
	}

}
