package exercice2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import exercice1.Cpg;

/**
 * Convertiseur de fichier.
 * 
 * <p>
 * Un convertisseur permet soit de crypter, soit de décrypter un fichier.
 */
abstract class Convertisseur {

	/**
	 * Nom du fichier à convertir.
	 */
	protected String fichier;
	
	// protected String fichierTmp;
	
	protected String fichierCoded;
	
	protected String fichierDecoded;
	
	protected String fichierCpg;

	/**
	 * Contenu du fichier à convertir.
	 */
	protected List<Integer> contenu;

	/**
	 * Crypteur utilisé pour crypter ou décrypter le fichier.
	 */
	protected Cpg crypteur;

	/**
	 * Indique si le fichier a déjà été converti.
	 */
	protected boolean converti;

	/**
	 * Constructeur.
	 * 
	 * @param fichier nom du fichier à convertir
	 */
	public Convertisseur(String path, String fichier, String ext) {
		this.fichier  = path + fichier;
		this.contenu  = new ArrayList<>();
		this.crypteur = null;
		this.converti = false;
		//this.fichierTmp = path + "tmp_" + fichier;
		this.fichierCoded = path + "coded_" + fichier + ext;
		this.fichierDecoded = path + "decoded_" + fichier + ext;
		this.fichierCpg = path + "cpg_" + fichier + ".cpg";
	}
	
	

	/**
	 * Démarre la conversion.
	 * 
	 * <p>
	 * La conversion démarre seulement si le fichier n'a pas déjà été converti.
	 */
	public abstract void start();

	
	
	/**
	 * Charge le fichier à convertir.
	 * 
	 * @throws IOException soulevée quand le fichier n'est pas accessible
	 */
	public void load() throws IOException {
		InputStream is = new BufferedInputStream(new FileInputStream(this.fichierCoded));
		System.out.println();
		int i;
		while ((i = is.read()) != -1)
		{
			//System.out.println(i);
			contenu.add(i);
		}
		is.close();
		//Reader r = new FileReader(fichier);
		
	}

	
	
	/**
	 * Converti et sauvegarde le fichier à convertir.
	 * 
	 * @param crypte indique si la conversion correspond au cryptage du fichier
	 * @throws IOException soulevée quand le fichier n'est pas accessible
	 */
	protected void convertAndSave(boolean crypte) throws IOException {
		
		if (crypte)
		{
			// Chiffrage
			OutputStream os = new BufferedOutputStream(new FileOutputStream(new File(this.fichierCoded)));
			
			Cpg crypteur = new Cpg(contenu);
			OutputStream cpgos = new BufferedOutputStream(new FileOutputStream(new File(this.fichierCpg)));
			ObjectOutputStream s = new ObjectOutputStream(cpgos);
			s.writeObject(crypteur);
			
			//System.out.println("Var initialisées");
			for( int i : contenu )
			{
				//System.out.println("i = " + i + " / crypteur = " + crypteur.CODE.get(i));
				//contenuChiffre.add(crypteur.CODE.get(i));
				os.write(crypteur.CODE.get(i));
				
			}
			os.close();
			cpgos.close();
		}  
		else
		{
			// Déchiffrage			
			OutputStream os = new BufferedOutputStream(new FileOutputStream(new File(this.fichierDecoded)));
			
			Cpg crypteur = new Cpg(contenu);
			InputStream cpgos = new BufferedInputStream(new FileInputStream(new File(this.fichierCpg)));
			ObjectInputStream s = new ObjectInputStream(cpgos);
			s.readO;
			
			//System.out.println("Var initialisées");
			for( int i : contenu )
			{
				//System.out.println("i = " + i + " / crypteur = " + crypteur.CODE.get(i));
				//contenuChiffre.add(crypteur.CODE.get(i));
				os.write(crypteur.DECODE.get(i));
				
			}
			os.close();
			cpgos.close();
		}
		
	}

}
