package exercice1;

import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Crypteur Pif Gadget.
 *
 * <p>
 * Un objet Cpg (<i>Crypteur Pif Gadget</i>) correspond à une liste d'octets
 * associée à une permutation quelconque de cette même liste d'octets.
 * 
 * <p>
 * Une liste de valeurs d'octets est fournie à la création. Cette liste est
 * mélangée aléatoirement. Un tableau associatif permet alors d'associer à
 * chaque élément de la liste d'origine un autre élément de la liste d'origine.
 */
public class Cpg implements Serializable {

	/**
	 * Identifiant de sérialisation.
	 */
	private static final long serialVersionUID = -5014568058113026043L;

	/**
	 * Tableau associant des paires d'octets.
	 */
	public final Map<Integer, Integer> CODE;

	/**
	 * Tableau réciproque de l'attribut code.
	 */
	public final Map<Integer, Integer> DECODE;

	/**
	 * Constructeur de Cpg.
	 * 
	 * @param l valeurs à utiliser pour construire les tableaux associatifs.
	 */
	public Cpg(List<Integer> l) {
		this.CODE   = new HashMap<>();
		this.DECODE = new HashMap<>();

		List<Integer> nouvlShuffled = new ArrayList<>();
		
		for(int i = 0 ; i < l.size() ; i++)
		{
			if (getNbOfIntOffset(l, l.get(i), i) == 1)
			{
				nouvlShuffled.add(l.get(i));
			}
		}

		List<Integer> nouvl = new ArrayList<>(nouvlShuffled);
		//nouvl = nouvlShuffled;
		
		Collections.shuffle(nouvlShuffled);
		
		
		// Map<Integer, Integer> forCode = new HashMap<Integer, Integer>();
		// Map<Integer, Integer> forDecode = new HashMap<Integer, Integer>();
		
		for (int i = 0 ; i < nouvl.size() ; i++)
		{
			this.CODE.put(nouvl.get(i), nouvlShuffled.get(i));
			this.DECODE.put(nouvlShuffled.get(i), nouvl.get(i));
		}
		
	}
	
	

	
	
	
	int getNbOfIntOffset(List<Integer> l, int target, int offset)
	{
		int count = 0;
		for (int i = offset ; i < l.size() ; i++)
		{
			if (l.get(i) == target)
				count ++;
		}
		return count;
	}
	
	
}