package img;

import java.awt.Color;

/**
 * Transformation : inversion symétrique d'image.
 */
public class Symetrie extends Transformation {

	/**
	 * Type de symétrie : true pour horizontale, false pour verticale.
	 */
	protected boolean horizontale;

	/**
	 * Constructeur : définit le type de symétrie.
	 * 
	 * @param horizontale type de symétrie : true pour horizontale, false pour
	 *                    verticale.
	 */
	public Symetrie(boolean horizontale) {
		this.horizontale = horizontale;
	}

	/**
	 * Applique une inversion symétrique à l'image.
	 * 
	 * @param pixels tableau source
	 * @return nouveau tableau correspondant à l'inversion symétrique de l'image
	 */
	@Override
	protected Color[][] transforme(Color[][] pixels) {
		// TODO EXERCICE 1 : à compléter...
		
		int nbLig = pixels.length;
		int nbCol = pixels[0].length;
		
		Color[][] res = new Color[nbLig][nbCol];
		
		
		
		/*
		if (this.horizontale)
			nbLig /= 2;
		else
			nbCol /= 2;
		*/

		
		for (int lig = 0 ; lig < nbLig ; lig++)
		{
			for (int col = 0 ; col < nbCol ; col++)
			{
				
				if (this.horizontale)
				{
					res[nbLig-1-lig][col] = pixels[lig][col];
				}
				else
				{
					res[lig][nbCol-1-col] = pixels[lig][col];
				}
				
			}
		}
		
		return res; // <- TODO résultat à adapter
	}

}
