package img;

import java.awt.Color;

/**
 * Transformation : réduction de l'image à une partie rectangulaire d'elle-même.
 * <p>
 * La partie rectangulaire est appelée zone de découpe et est identifiée par un
 * point en haut à gauche, par une largeur et par une longueur.
 * <p>
 * <b>Attention</b> : la zone de découpe doit être entièrement incluse dans
 * l'image.
 */
public class Decoupe extends Transformation {

	/**
	 * Abscisse du point en haut à gauche de la zone de découpe.
	 */
	protected int x;

	/**
	 * Ordonnée du point en haut à gauche de la zone de découpe.
	 */
	protected int y;

	/**
	 * Largeur de la zone de découpe (nombre de pixels).
	 */
	protected int largeur;

	/**
	 * Hauteur de la zone de découpe (nombre de pixels).
	 */
	protected int hauteur;

	/**
	 * Constructeur : initialise la zone de découpe.
	 * 
	 * @param x       abscisse du point en haut à gauche de la zone de découpe
	 * @param y       ordonnée du point en haut à gauche de la zone de découpe
	 * @param largeur largeur de la zone de découpe (nombre de pixels)
	 * @param hauteur hauteur de la zone de découpe (nombre de pixels)
	 */
	public Decoupe(int x, int y, int largeur, int hauteur) {
		this.x = x; // colonne
		this.y = y; // ligne
		this.largeur = largeur;
		this.hauteur = hauteur;
	}

	/**
	 * Tente de réduire l'image à sa zone de découpe.
	 * <p>
	 * Le nouveau tableau renvoyé en résultat correspond à la zone de découpe si la
	 * zone est bien incluse dans l'image.
	 * 
	 * @param pixels tableau source
	 * @return nouveau tableau correspondant à la découpe si la zone est correcte,
	 *         null sinon
	 */
	@Override
	protected Color[][] transforme(Color[][] pixels) {
		// TODO EXERCICE 2 : à compléter...
		
		int nbLig = pixels.length;
		int nbCol = pixels[0].length;
		
		if (this.x + this.largeur >= nbCol || this.y + this.hauteur >= nbLig)
		{
			return null;
		}
		
		Color[][] res = new Color[this.hauteur][this.largeur];
		
		for (int lig = this.y ; lig < this.hauteur ; lig++)
		{
			for (int col = this.x ; col < this.largeur ; col++)
			{
				
				res[lig-this.y][col-this.x] = pixels[lig][col];
				
			}
		}
		
		return res; // <- TODO résultat à adapter
	}

}
