package exercice7;

import exercice3.Iterateur;
import exercice4.Comparateur;
import exercice6.Ensemble;

/**
 * Représente un ensemble d'objets quelconques grâce à une chaîne d'objets.
 * <p>
 * 
 * Les éléments de l'ensemble sont stockés dans des chaînons reliés entre eux
 * par un simple chaînage.
 * <p>
 * 
 * La classe stocke la référence du chaînon de début de chaîne ainsi que la
 * taille de la chaîne (<i>i.e.</i> nombre d'éléments dans l'ensemble).
 */
public class ChaineEnsemble implements Ensemble {

	/**
	 * Représente un chaînon de la chaîne avec une valeur stockée et la référence du
	 * chaînon suivant dans la chaîne.
	 */
	@SuppressWarnings("unused")
	private static class Chainon {

		/**
		 * Référence de l'objet stocké.
		 */
		Object val;

		/**
		 * Référence du chaînon suivant dans la chaîne.
		 */
		Chainon next;

		/**
		 * Initialise un chaînon à partir d'un objet à stocker et de la référence du
		 * chaînon suivant.
		 * 
		 * @param val  référence de l'objet à stocker
		 * @param next référence du chaînon suivant (peut être null)
		 */
		Chainon(Object val, Chainon next) {
			this.val = val;
			this.next = next;
		}
	}

	/**
	 * Représente un itérateur sur un ensemble de type ChaineEnsemble.
	 * <p>
	 * 
	 * L'itérateur est matérialisé par référence du prochain chaînon à lire dans la
	 * chaîne.
	 */
	@SuppressWarnings("unused")
	private class ChaineEnsembleIterateur implements Iterateur {

		// ----- Attributs -----

		// TODO à définir
		
		// ----- Constructeur -----

		// TODO à définir

		// ----- Méthodes -----

		@Override
		public boolean hasNext() {
			// TODO à compléter...
			return false; // <- TODO résultat à adapter
		}

		@Override
		public Object next() {
			// TODO à compléter...
			return false; // <- TODO résultat à adapter
		}

	}

	// ----- Attributs -----

	// TODO à définir
	
	// ----- Constructeur -----

	// TODO à définir

	// ----- Méthodes -----

	@Override
	public String toString() {
		// TODO à compléter...
		return null; // <- TODO résultat à adapter
	}

	@Override
	public void add(Object o) {
		// TODO à compléter
	}

	@Override
	public void remove(Object o) {
		// TODO à compléter
	}

	@Override
	public int size() {
		// TODO à compléter...
		return -1; // <- TODO résultat à adapter
	}

	@Override
	public boolean contains(Object o) {
		// TODO à compléter...
		return false; // <- TODO résultat à adapter
	}

	@Override
	public Iterateur getIterateur() {
		// TODO à compléter...
		return null; // <- TODO résultat à adapter
	}

	@Override
	public Object min(Comparateur c) {
		// TODO à compléter...
		return null; // <- TODO résultat à adapter
	}

	@Override
	public Object max(Comparateur c) {
		// TODO à compléter...
		return null; // <- TODO résultat à adapter
	}

	@Override
	public ChaineEnsemble clone() {
		// TODO à compléter...
		return null; // <- TODO résultat à adapter
	}
}
