package exercice2;

import java.util.Arrays;

import exercice1.Ensemble;

/**
 * Représente un ensemble d'objets quelconques grâce à un tableau.
 * <p>
 * 
 * Les éléments de l'ensemble sont stockés dans un tableau réalloué par blocs.
 * Quand le tableau est plein, il est réalloué avec n cases en plus. Ces n cases
 * constituent un bloc.
 * <P>
 * 
 * De même, quand les cases libres du tableau constituent un bloc entier, le
 * tableau est réalloué avec un bloc de cases en moins.
 */
public class TabEnsemble implements Ensemble {

	// ----- Attributs -----

	private static final int TAILLEBLOC = 5;
	private Object tab[];
	private int pi;
	
	
	// ----- Constructeur -----

	public TabEnsemble()
	{
		this.tab = new Object[TAILLEBLOC];
		this.pi = 0;
	}



	// ----- Méthodes -----

	@Override
	public String toString() {
		String res = "[ ";
		for (int i = 0 ; i < pi ; i++)
		{
			res += tab[i] + " ";
		}
		return res + "]";
	}

	// --------------------

	@Override
	public void add(Object o) {
		if (this.tab.length-pi == 0)
		{
			this.tab = Arrays.copyOf(this.tab, this.tab.length+TAILLEBLOC);
		}
		
		if (o != null && !this.contains(o))
		{
			this.tab[this.pi] = o;
			this.pi++;
		}
			
	}

	@Override
	public void remove(Object o) {
		if (o != null && this.contains(o))
		{
			for (int i = 0 ; i < this.pi ; i++)
			{
				if (o.equals(this.tab[i]))
				{
					this.tab[i] = this.tab[this.pi-1];
					this.pi--;
				}
			}
		}
	}

	@Override
	public int size() {
		return this.pi;
	}

	@Override
	public boolean contains(Object o) {
		if (o == null)
			return false;
		
		for (int i = 0 ; i < pi ; i++)
		{
			if (o.equals(tab[i]))
				return true;
		}
		return false;
	}

}
