package exercice4;

import java.util.Arrays;

import exercice1.Evolution;

/**
 * Grille d'automate cellulaire.
 * <p>
 * 
 * La grille est un tableau de cellules. Une cellule n'a que deux états
 * possibles : <i>vivante</i> et <i>morte</i>. Ces états sont représentés par
 * des valeurs booléennes :
 * <ul>
 * <li><tt>true</tt> : <i>vivante</i></li>
 * <li><tt>false</tt> : <i>morte</i></li>
 * </ul>
 * Le tableau de cellules est donc concrètement un tableau de booléens.
 */
@SuppressWarnings("unused") // <- TODO : à supprimer
public class Grille {

	// ******************************* ATTRIBUTS

	/**
	 * Tableau de cellules.
	 */
	protected boolean[][] cellules;

	/**
	 * Nombre de lignes.
	 */
	public final int NL;

	/**
	 * Nombre de colonnes.
	 */
	public final int NC;

	/**
	 * Règles d'évolution de la grille.
	 */
	protected Evolution evo;

		
		
		
	
	
	
	// ******************************* CONSTRUCTEURS

	/**
	 * Constructeur : initialise la grille à partir d'un tableau fourni en
	 * paramètre.
	 * 
	 * @param cellules Etat initial du tableau de cellules
	 * @param evo      Règles d'évolution
	 */
	public Grille(boolean[][] cellules, Evolution evo) {

		this.cellules = cellules;
		this.NL = cellules.length;
		this.NC = cellules[0].length;
		this.evo = evo;
		
	}
	
	/**
	 * Constructeur : initialise la grille à partir de ses dimensions et d'un
	 * pourcentage de cellules initialement vivantes réparties aléatoirement.
	 *
	 * @param nbL  Nombre de lignes
	 * @param nbC  Nombre de colonnes
	 * @param taux Pourcentage de cellules initialement vivantes
	 * @param evo  Règles d'évolution
	 */
	public Grille(int nbL, int nbC, int taux, Evolution evo) {

		//this(nbL, nbC, evo);
		this.cellules = new boolean[nbL][nbC];
		this.NL = nbL;
		this.NC = nbC;
		this.evo = evo;
		
		
		// * Répartition aléatoire
		for (int l = 0 ; l < nbL ; l++)
		{
			for (int c = 0 ; c < nbC ; c++)
			{
				int proba = (int) (Math.random()*101);
				if (proba <= taux)
					this.cellules[l][c] = true;
				else
					this.cellules[l][c] = false;
				
			}
		}
		
	}

	/**
	 * Constructeur : crée une grille dont toutes les cellules sont initialement
	 * mortes.
	 * 
	 * @param nbL Nombre de lignes
	 * @param nbC Nombre de colonnes
	 * @param evo Règles d'évolution
	 */
	public Grille(int nbL, int nbC, Evolution evo) {

		this.cellules = new boolean[nbL][nbC];
		
		for (boolean[] ligne : cellules)
		{
			Arrays.fill(ligne, false);			
		}
		
		this.NL = nbL;
		this.NC = nbC;
		this.evo = evo;
		
	}

	
	
	
	
	
	// ******************************* METHODES

	/**
	 * Représentation textuelle de la grille, ligne par ligne, avec . pour une
	 * cellule morte, et O pour une cellulle vivante.
	 * 
	 * @return Représentation de la grille.
	 */
	@Override
	public String toString() {

		String res = "";
		
		for (boolean[] ligne : this.cellules)
		{
			for (boolean cell : ligne)
			{
				res += (cell ? "0" : ".");
			}
			
			res += "\n";
		}
		
		return res;
		
		
	}
	
	
	// **ATTENTION**
	//
	// Le copier/coller risque de faire apparaître
	// des clauses import indésirables en entête de ce ficher
	// 
	// La seule clause import utile est la suivante (il faut supprimer les autres) :
	//
	//     import exercice1.Evolution;
	
	
	
	/**
	 * Fournit une cellule désignée par ses coordonnées dans la grille, ou false si
	 * les coordonnées sont incorrectes
	 * 
	 * @param i Numéro de ligne de la cellule.
	 * @param j Numéro de colonne de la cellule.
	 * @return Cellule désignée par (i, j)
	 */
	public boolean get(int i, int j) {
	
		
		if (i < 0 || i > this.NL-1 || j < 0 || j > this.NC-1)
		{
			return false;
		}
		// Si i|j <0 ou >max, remise à 0 ou max, sinon i|j
		//int l = (i<0 ? 0 : (i>=this.NL ? this.NL-1 : i));
		//int c = (i<0 ? 0 : (i>=this.NL ? this.NL-1 : i));
		return this.cellules[i][j];	
		
		
		
	}
	
	/**
	 * Met à jour la cellule de la case désignée par ses coordonnées dans la grille
	 * (si les coordonnées existent).
	 * 
	 * @param i       Numéro de ligne de la cellule.
	 * @param j       Numéro de colonne de la cellule.
	 * @param cellule Cellule à déposer dans la case désignée par (i, j)
	 */
	public void set(int i, int j, boolean cellule) {
	
		this.cellules[outMinMax(i, 0, this.NL-1)][outMinMax(j, 0, this.NC-1)] = cellule;
		
	}
	
	/**
	 * Fournit le nombre de cellules vivantes dans le voisinage direct d'une
	 * cellule.
	 * 
	 * @param i Numéro de ligne de la cellule.
	 * @param j Numéro de colonne de la cellule.
	 * @return Nombre de cellules vivantes autour de la cellule
	 */
	public int nbVoisins(int i, int j) {
	
		//int l = (i<0 ? 0 : (i>=this.NL ? this.NL-1 : i));
		//int c = (i<0 ? 0 : (i>=this.NL ? this.NL-1 : i));
		int res = 0;


			
		for (int l = outMinMax(i-1, 0, this.NL-1) ; l <= outMinMax(i+1, 0, this.NL-1) ; l++)
		{
			for (int c = outMinMax(j-1, 0, this.NC-1) ; c <= outMinMax(j+1, 0, this.NC-1) ; c++)
			{
				if ((l != i   ||   c != j)  &&  (i >= 0 || i <= this.NL-1 || j >= 0 || j <= this.NC-1))
				{
					res += (this.cellules[l][c]==true ? 1 : 0);
				}
			}
		}
		
		return res; // <- TODO à mettre à jour !
		
	}
	
	
	
	static public int outMinMax(int i, int min, int max)
	{		
		return (i<min ? min : (i>max ? max : i));
	}
	

	/**
	 * Etape d'évolution : met à jour l'état de la grille en appliquant les règles
	 * d'évolution sur toutes les cases.
	 */
	public void next() {
		
		boolean[][] nouvellesCellules = new boolean[this.NL][this.NC];

		for (int l = 0 ; l < this.NL ; l++)
		{
			for (int c = 0 ; c < this.NC ; c++)
			{
				nouvellesCellules[l][c] = this.evo.etatSuivant(cellules[l][c], nbVoisins(l, c));
			}
		}
		
		this.cellules = nouvellesCellules;
		
	}

	/**
	 * Fait évoluer la grille de plusieurs étapes.
	 * 
	 * @param nbsteps nombre d'étapes
	 */
	public void next(int nbsteps) {

		for (int i = 0 ; i < nbsteps ; i++)
		{
			this.next();
		}
		
	}
	
}
