package exercice1;

/**
 * Représente les règles d'évolution d'un automate cellulaire.
 * <p>
 *
 * Dans une case de l'automate, une cellule naît ou au contraire disparaît si
 * son voisinage direct contient un nombre précis de cellules (nombre parmi
 * plusieurs possible).
 */
public class Evolution {
	
	// ******************************* ATTRIBUTS STATIQUES
	
	// Règles prédéfinies

	public static final Evolution CONWAY = 
			new Evolution(new int[] { 2, 3 }, new int[] { 3 });
	
	public static final Evolution DAYANDNIGHT = 
			new Evolution(new int[] { 3, 4, 6, 7, 8 }, new int[] { 3, 6, 7, 8 });
			
	public static final Evolution HIGHLIFE = 
			new Evolution(new int[] { 2, 3 }, new int[] { 3, 6 });

	
	
	
	// ******************************* ATTRIBUTS D'INSTANCES

	/**
	 * Nombres de cellules vivantes dans l'environnement d'une cellule vivante qui
	 * lui permettent de survivre.
	 */
	@SuppressWarnings("unused") // <- TODO : à supprimer
	private int[] nbSurvie;

	/**
	 * Nombres de cellules vivantes dans l'environnement d'une cellule morte qui lui
	 * permettent de renaitre.
	 */
	@SuppressWarnings("unused") // <- TODO : à supprimer
	private int[] nbNaissance;

	
	
	
	
	
	
	// ******************************* CONSTRUCTEUR

	/**
	 * Constructeur : initialisation des tableaux
	 * 
	 * @param nbSurvie    Valeur initiale de l'attribut nbSurvie
	 * @param nbNaissance Valeur initiale de l'attribut nbNaissance
	 */
	public Evolution(int[] nbSurvie, int[] nbNaissance) {

		this.nbSurvie = nbSurvie;
		this.nbNaissance = nbNaissance;		
		
	}
	
	
	
	
	
	
	

	// ******************************* METHODES

	/**
	 * Indique si un nombre de cellules vivantes fourni en paramètre permettra à une
	 * cellule de naître.
	 * 
	 * @param nbv Nombre de cellules vivantes
	 * @return vrai si nbv permet la naissance d'une nouvelle cellule
	 */
	public boolean naitra(int nbv) {

		for (int val : this.nbNaissance) // * Parcours tous les nombres permettant la naissance
		{
			if (val == nbv) // * Si un des ces nombres correspond à celui indiqué en paramètre ...
				return true;
		}
		return false;
		
		
	}

	
	
	/**
	 * Indique si un nombre de cellules vivantes fourni en paramètre permettra à une
	 * cellule de survivre.
	 * 
	 * @param nbv Nombre de cellules vivantes
	 * @return vrai si nbv permet la survie d'une cellule existante
	 */
	public boolean survivra(int nbv) {

		for (int val : this.nbSurvie) // * Parcours tous les nombres permettant la survie
		{
			if (val == nbv) // * Si un des ces nombres correspond à celui indiqué en paramètre ...
				return true;
		}
		return false;
		
		
	}

	/**
	 * Indique le prochain état d'une cellule conformément aux règles d'évolution.
	 * <p>
	 * 
	 * Une cellule est vivante à l'étape suivante si et seulement si elle est
	 * vivante et survivra, ou si elle est morte et renaitra.
	 * 
	 * @param cellule Etat de la cellule (true : vivante, false : morte)
	 * @param nbv     nombre de cellules vivantes dans le voisinage de la cellule
	 * @return true si la cellule est en vie à l'étape suivante, false sinon
	 */
	public boolean etatSuivant(boolean cellule, int nbv) {
		
		if (cellule && survivra(nbv) || !cellule && naitra(nbv)) // * Si cell vivante et survivra() OK --ou-- si cell morte et naitra OK, alors ...
			return true;

		return false;
		
	}

}
