package scolarite;

import java.util.Arrays;

public class Promotion {
	
	String nom;
	protected Etudiant[] etudiants;
	
	
	// Constructeurs
	
	public Promotion(String nom) {
		this.nom = nom;
		this.etudiants = new Etudiant[0];
	}
	
	public Promotion(String nom, Etudiant... te)
	{
		this(nom);
		// this.etudiants = te;
		// Possible mais problématique en cas d'une instance Etudiant indiquée à plusieurs reprises en paramètre.
		for (int i = 0 ; i < te.length ; i++)
		{
			this.addE(te[i]);
		}
		
	}
	
	
	
	// Méthodes

	// Renvoie false si e n'est pas dans la promo, sinon true.
	public boolean delE(Etudiant e)
	{
		if (! this.equals(e.promo))
			return false;
		else
		{
			int ie = 0;
			while (this.etudiants[ie] != e)
				ie++;
			
			this.etudiants[ie] = this.etudiants[this.etudiants.length - 1];
			this.etudiants = Arrays.copyOf(this.etudiants, this.etudiants.length-1);
			
			e.promo = null;

			return true;
		}
			
	}
	
	// 
	public boolean addE(Etudiant e)
	{
		if (this.equals(e.promo))
			return false;
		if (e.promo != null)
			e.promo.delE(e);
		
		this.etudiants = Arrays.copyOf(this.etudiants, this.etudiants.length+1);
		this.etudiants[this.etudiants.length-1] = e;
		e.promo = this;
		return true;	
	}
	
	
	
	public double moyennePromo()
	{
		return Etudiant.moyenneGenerale(etudiants);
	}
	
	

	
	
	@Override
	public String toString() {
		String res = this.nom;
		
		for (Etudiant e : this.etudiants)
		{
			res += " [" + e + "]"; // implicitement e.toString()
		}
		
		return res;
	}

}
