package scolarite;

import java.util.Arrays;

public class Etudiant {


	String nom;
    String prenom; 
    double[] notes;
    Promotion promo;
    String id;
    static int nextNum = 1;

    
    // Constructeurs
    
    public Etudiant(String nom, String prenom)
    {
        this.nom = nom;
        this.prenom = prenom;
        this.notes = new double[0];
        this.promo = null;
        this.id = this.nom.toLowerCase() + this.nextNum++; // évalué avec incrémentation
    }
    
    public Etudiant(String nom, String prenom, Promotion promo)
    {
    	this(nom, prenom);
    	promo.addE(this);
    }
    
    
    
    
    
    // Méthodes
    
    
    public void addNote(double n)
    {
    	// double[] notes = new double[this.notes.length+1];
    	double[] nouvNotes = Arrays.copyOf(this.notes, this.notes.length+1);
    	nouvNotes[nouvNotes.length-1] = n;
    	this.notes = nouvNotes;
    }
    
    public double moyenne()
    {
    	
    	if (this.notes.length == 0)
    		return 0;

    	double sommeNotes = 0;
    	
    	for (double n : this.notes)
    	{
    		sommeNotes += n;
    	}
    	
    	
    	
    	return sommeNotes / this.notes.length;	
    }
    
    // Utilisation de static puisque aucun 'this' utilisé. (static = pas de receveur)
    // Non exécuté depuis un étudiant (= non exécuté depuis un receveur).
    public static double moyenneGenerale(Etudiant[] tab)
    {
    	double m = 0;
    	for (Etudiant e : tab)
    		m += e.moyenne();
    	
    	if (tab.length != 0)
    		m /= tab.length;
    	return m;
    }
    
    

    
    
    
    
    
    @Override
    public String toString() {
    	String res = this.nom.toUpperCase() + " "; // Einstein
    	res += String.valueOf(this.prenom.charAt(0)).toUpperCase(); // A
    	res += this.prenom.substring(1).toLowerCase() + " :"; // lbert
    	for (double n : this.notes)
    	{
    		res += " " + n;
    	}
    	return res;
    	// return "Etudiant [nom=" + nom + ", prenom=" + prenom + ", notes=" + Arrays.toString(notes) + "]";
    }
    
    

}