/* lecture du fichier des distances
 * dans une matrice carree de taille
 */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>



// remplissage de la matrice Distances
// de taille (TOWNS+1) * (TOWNS+1)
// pour numerotation à partir de 1
#define TOWNS 24
#define THRESH  300
#define INFTY  INT_MAX

int Distances[TOWNS+1][TOWNS+1];
void readDistances (char *filename)
{
	int i, j, k;
	int distance;
	FILE *fp = fopen(filename, "r");

	if (!fp) exit(-1);

	for (j=1; j<=TOWNS; j++) {
		Distances[j][j] = 0;
		for (i=1; i<j; i++) {
			fscanf(fp, "%d", &(Distances[i][j]));
			if (Distances[i][j] < THRESH)
				Distances[j][i] = Distances[i][j];
			else
				Distances[i][j] = Distances[j][i] = INFTY;
		}
	}
	fclose(fp);
}


int cheminDijkstra(int dep, int arr, int C[TOWNS+1])
{
	int D[TOWNS+1];
	int E[TOWNS+1];
	
	// * init
	for (int i = 0 ; i < TOWNS+1 ; i++)
	{
		D[i] = PLUS_INF; // * Toutes les destinations ont comme distances infini
		C[i] = dep; // * 
		E[i] = 0; // * toutes les villes n'ont pas été vues
	}

	
	while (1) {
		// * calc min
		int imin = -1, vmin = INFTY;
		for (int i = 1 ; i < TOWNS+1 ; i++)
		{
			if (E[i]==0 && D[i]<vmin)
			{
				imin = i;
				vmin = D[i];
			}
		}
		if (imin = -1) break;
		E[imin] = 1;
		

		// * maj succs
		for (int j = 1 ; j < TOWNS+1 ; j++)
		{
			// * Distance[imin][j] ???
			float lgarc = Distances[imin][j];
			int succ = j;
			if (lgarc == INFTY) continue; // * Ce n'est pas un voisin.
			
			if (D[imin] + lgarc < D[succ])
			{
				D[succ] = D[imin] + lgarc;
				C[succ] = imin;
			}
		}
		
	}

	return D[arr];
}



void readTowns(char *fname)
{
	FILE *fp = fopen(fname, "r");
	int i = 1;
	
	// * rappel : scanf("%d", &val); => fscanf(fp, "%d", &val);
	// *                             => retourne le nb de valeurs lues (1 ici)
	
	while (fscanf(fp, "%s%f%f", &(infoTowns[i].nom), &(infoTowns[i].lon), &(infoTowns[i].lat)) == 3)
	{
		i++;
	}
	
	fclose(fp);
}


void printPath(char *fname, int dep, int arr, int c[])
{
	FILE *fp = fopen(fname, "w");
	int i = arr;
	
	while (1)
	{
		fprintf(fp, "%s %f %f\n", infoTowns[i].nom, infoTowns[i].lon, infoTowns[i].lat);
		if (i == dep) break;
		i = C[i];
	}
	fclose(fp);
}




// exemple d'utilisation

int main() {
        int som, dep = 3 /* Brest */, arr = 17 /* Nice */;
        int dist;
        int C[TOWNS+1];

        readDistances("distances.dat");
        //readTowns("villes.dat");

        // * test de l'algorithme de Dijkstra
        dist = cheminDijkstra(dep, arr, C);
        printf("distance totale : %d\n", dist);

        // printPath("trajet.dat", dep /* Brest */, arr /* Nice */, C);
        // system("gnuplot plot.script");

	// * generer dans aretes.dat la liste des aretes (2 lignes / arete + 1 ligne blanche)
	// system("gnuplot plotGraph.script");
	// * le graphe utilisé sera dans graph.gif
	
	return 0;

}

