/*
 * dijkstra.c
 * L. Lemarchand
 * 29/02/2000
 *
 * implantation de l'algorithme de Dijkstra
 */

#include <stdio.h>
#include <stdlib.h>
#include "graphe.h"

/*
 * algorithme de Dijkstra.
 * a completer pour le TP 1.
 *
 * retourne un tableau D (de taille graphe->nb_sommets)
 * contenant pour chaque sommet i la
 * distance minimale de i0 a i
 */

int *dijkstra(int i0, graphe_t *graphe, int *C)
{
	int i;
	/* E est un tableau de nb_sommets. 
	 * E[i] == 0 si i n'est pas encore inclus dans E,
	 * E[i] == 1 sinon
	 *
	 * D est un tableau de nb_sommets.
	 * a la fin de l'algorithme, D[i] vaut la distance
	 * minimale de i0 a i
	 */

	int *D = int_alloc(graphe->nb_sommets);
	int *E = int_alloc(graphe->nb_sommets);

	// A vous
	// init
	for(i=0; i<graphe->nb_sommets; i++) {
		D[i] = PLUS_INF;
		E[i] = 0;
		C[i] = i0;
	}
	D[i0] = 0;
	

	while (1) {
		// calcul du sommet imin suivant
		int imin = -1, valmin = PLUS_INF;
		for(i=0; i<graphe->nb_sommets; i++) {
			if (D[i] < valmin && E[i] == 0) {
				valmin = D[i];
				imin = i;
			}
		}

		// verification fin de l'algo
		if (imin == -1) break;
		E[imin] = 1;

		// mise à jour des successeurs j de imin
		for(int arc=graphe->lp[imin]  ; arc<graphe->lp[imin+1]; arc++) {
			int succ = graphe->final[arc];
			int lgarc = graphe->poids[arc];
			int lgchemin = D[imin] + lgarc;

			D[succ] //?

		}

	}
	free(E);
	return D;
}

