#include <stdio.h>

#define PERIOD 5
int Bitrates[1024];

int readBitrates(char nomfic[])
{
	FILE *fp = fopen(nomfic, "r");
	if (!fp) return 0;

	int i = 0;
	while (fscanf(fp, "%d", Bitrates+i) == 1) i++;
	fclose(fp);
	return i;
}


int costInterval(int i, int j)
{
    int valMax = 0;
    for (int x = i ; x < j ; x++)
        if (Bitrates[x] > valMax)
            valMax = Bitrates[x];
    
    int valSom = 0;
    for (int x = i ; x < j ; x++)
        valSom += (valMax - Bitrates[x]);
    
    return valSom;
}




#include <limits.h>

int bellman(int n) 
{
	int D[n+1];
	
	D[0] = 0;
	for (int i = 1 ; i < n+1 ; i++)
        D[i] = INT_MAX;
        
    for (int j = 1 ; j < n+1 ; j++)
    {
        int firstPred = 0;
        int lastPred = j - PERIOD;
        
        for (int i=firstPred ; i <= lastPred ; i++)
        {
            if (D[i] == INT_MAX)
                continue;
            int val = D[i] + costInterval(i, j);
            if (val < D[j])
                D[j] = val;
        }
            
    }
	
	return D[n];
}




int main ()
{
    printf("________________________________________\n________________________________________\n\n");
    
    int dernierI = readBitrates("bbb_cif_baseline_mean");
    printf("Dernière valeur : %d\n", Bitrates[dernierI-1]);
    printf("Derneir i : %d\n", dernierI);
    printf("Nb bits (di+1) : %d\n", dernierI+1);
    
    printf("----------\n");
    
    int cout = costInterval(0, 7);
    printf("Coût de %d à %d = %d\n", cout, 0, 7);
    
    printf("----------\n");
    
    printf("Coût de %d pour une période de %d.\n", bellman(dernierI), PERIOD);
    
    printf("________________________________________\n________________________________________\n\n");
}