#include <stdio.h>

#define PERIOD 5
int Bitrates[1024];

int readBitrates(char nomfic[])
{
	FILE *fp = fopen(nomfic, "r");
	if (!fp) return 0;

	int i = 0;
	while (fscanf(fp, "%d", Bitrates+i) == 1) i++;
	fclose(fp);
	return i;
}

int costInterval(int i, int j)
{
	int k, max = Bitrates[i];
	for(k=i+1; k<j; k++)
		if (Bitrates[k]>max) max = Bitrates[k];

	int sum = 0;
	for(k=i; k<j; k++)
		sum += max - Bitrates[k];

	return sum;
}

#include <limits.h>

int bellman(int n) 
{
	int i, j;
	int D[n+1];

	D[0] = 0;
	for(i=1; i<=n; i++) D[i] = INT_MAX;

	for(j=PERIOD+1; j<=n; j++) {
		int last = j - PERIOD;
		if (j==n) last = j - 1;
		for(i=0 ; i<=last; i++) {
			int v = D[i] + costInterval(i, j);
			if (v < D[j]) // maj
				D[j] = v;
		}
	}
	return D[n];
}


int main()
{
	int nbits = readBitrates("bbb_cif_baseline_mean");
	printf("dernier %d\n", Bitrates[nbits-1]);
	printf("cost= %d pour i=%d et j=%d\n", costInterval(2,7), 2, 7);
	printf("pour P=%d, cost=%d\n", PERIOD, bellman(nbits));

}

