package Interface;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

import java.awt.BorderLayout;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.Color;
import javax.swing.AbstractAction;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

import javax.swing.JPasswordField;
import javax.swing.ImageIcon;
import java.awt.Font;

/**
*
* @author  Le Tareau Gwendal, Cauba Deniel, Pichon Thibault
* @version 0.4.7
* @since   2020-10-18
*/


public class FenetreConnexion {

	
	public JFrame frmConnection;
	private JTextField txtIdentifiant;
	private JButton btnNewButton;
	private final Action action_1 = new ConnexionBoutton();
	private JPasswordField passwordField;
	private JLabel lblNewLabel;
	private JLabel lblVersion;

	/**
	 * Lance l'application.
	 * @param args
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					FenetreConnexion window = new FenetreConnexion();
					window.frmConnection.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Cre la fentre.
	 */
	public FenetreConnexion() {
		initialize();
	}

	/**
	 * Innitialise le contenu de la fentre.
	 * @param args
	 */
	private void initialize() {
		frmConnection = new JFrame();
		frmConnection.getContentPane().setBackground(new Color(153, 204, 255));
		frmConnection.setBackground(Color.ORANGE);
		frmConnection.setResizable(false);
		frmConnection.setTitle("Connexion");
		frmConnection.setBounds(100, 100, 450, 300);
		frmConnection.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmConnection.getContentPane().setLayout(null);
		
		JLabel lblIdentifiant = new JLabel("Identifiant :");
		lblIdentifiant.setForeground(Color.BLACK);
		lblIdentifiant.setBounds(63, 74, 70, 25);
		frmConnection.getContentPane().add(lblIdentifiant);
		
		JLabel lblApplifrais = new JLabel("AppliGSB");
		lblApplifrais.setFont(new Font("Tahoma", Font.BOLD | Font.ITALIC, 15));
		lblApplifrais.setBounds(182, 30, 101, 14);
		frmConnection.getContentPane().add(lblApplifrais);
		
		txtIdentifiant = new JTextField();
		txtIdentifiant.setBounds(143, 76, 160, 20);
		frmConnection.getContentPane().add(txtIdentifiant);
		txtIdentifiant.setColumns(10);
		
		JLabel lblMotDePasse = new JLabel("Mot de passe :");
		lblMotDePasse.setForeground(Color.BLACK);
		lblMotDePasse.setBounds(63, 122, 84, 14);
		frmConnection.getContentPane().add(lblMotDePasse);
		
		btnNewButton = new JButton("New button");
		btnNewButton.setForeground(Color.WHITE);
		btnNewButton.setBackground(Color.BLUE);
		btnNewButton.setAction(action_1);
		btnNewButton.setBounds(147, 168, 136, 23);
		frmConnection.getContentPane().add(btnNewButton);
		
		passwordField = new JPasswordField();
		passwordField.setBounds(155, 119, 148, 20);
		frmConnection.getContentPane().add(passwordField);
		
		lblNewLabel = new JLabel("");
		lblNewLabel.setIcon(new ImageIcon("E:\\BUREAU\\bts\\Deuxiemeannee\\PPE\\GSB\\Logo_GSB2.png"));
		lblNewLabel.setBounds(254, 150, 244, 126);
		frmConnection.getContentPane().add(lblNewLabel);
		
		lblVersion = new JLabel("Version 0.4.7");
		lblVersion.setBounds(350, 11, 84, 14);
		frmConnection.getContentPane().add(lblVersion);
		
	}
	
	/**
	 * Cette mthode va chercher les utilisateurs de la base de donnes et les envoys dans notre tableau
	 * 
	 * @param requette
	 * @param tableRecup
	 * @return les rsultats de la requte
	 */
	
	public static int sendRequette1tableInt(String requette, String tableRecup){
		
	    Connection connect;
		try {
			connect = DriverManager.getConnection("jdbc:mysql://localhost/gsb_frais", "root", "");
			Statement stmt = connect.createStatement();
		    ResultSet rs = stmt.executeQuery(requette);
		    rs.next();
		    return rs.getInt(tableRecup);
		} catch (SQLException e) {
			
			JOptionPane.showMessageDialog(null, e.getMessage());
		}
		return 0;
	    
	}
	
	/**
	 * Cette mthode va executer une action lorsque l'on click sur le bouton "Se connecter" 
	 * Elle va envoyer une requte SQL a la base de donnes pour verifier que le login et le mot de passe correspondent
	 * Si ils correspondent cette mthode va ouvrir la fentre "FenetreAffichage2", sinon elle affichera une fentre d'erreur
	 * @param e
	 * 
	 */
	private class ConnexionBoutton extends AbstractAction {
		public ConnexionBoutton() {
			putValue(NAME, "Se connecter");
			putValue(SHORT_DESCRIPTION, "Se connecter a la base de donn\u00E9es");
		}
		@SuppressWarnings("deprecation")
		public void actionPerformed(ActionEvent e) {
			try {
				
							
				Connection connexion = null;
				System.out.println("Le pilote JDBC MySQL a été chargé");

	            connexion = DriverManager.getConnection("jdbc:mysql://localhost/gsb_frais", "root", "");
	            
	            
	            String requette = "SELECT COUNT(*) AS nbrUser FROM utilisateurs WHERE login = '" + txtIdentifiant.getText() + "' AND mdp = '" + passwordField.getText() + "' AND AutoriseAcces = 1;";
	    	    String tableRecup = "nbrUser";
	    	    if (sendRequette1tableInt(requette, tableRecup) == 1) {
	    	    	FenetreAffichage2 fenetre = new FenetreAffichage2();
					fenetre.frmGestionUtilisateur.setVisible(true);
					frmConnection.dispose();
	    	    } else {
	    	    	try {
	    	    		Object[] choux={"OK"};
	    		        int choix = JOptionPane.showOptionDialog(null, 
	    		                    "Mauvais Login ou MDP", 
	    		                    "Erreur de connexion", 
	    		                    JOptionPane.YES_NO_OPTION, 
	    		                    JOptionPane.WARNING_MESSAGE, 
	    		                    null, choux, choux[0]);
	    		        
		            } catch (Exception u) {
						u.printStackTrace();
		            }
	    	    } 
	            
	           
	           

				
			} catch (Exception t) {
				t.printStackTrace();
			}
			
			}
		}
}
