package tests;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

import association.InformationPersonnelle;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

/**
 * Tests JUnit de la classe {@link association.InformationPersonnelle
 * InformationPersonnelle}.
 *
 * @author Eric Cariou
 * @see association.InformationPersonnelle
 */
class TestInformationPersonnelle {
  
  /**
   * Une information basique : prnom et nom.
   */
  private InformationPersonnelle infoBasique;
  /**
   * Une information complte : prnom, nom, adresse et age.
   */
  private InformationPersonnelle infoComplete;
  
  /**
   * Instancie une information basique et une complte pour les tests.
   *
   * @throws Exception ne peut pas tre leve ici
   */
  @BeforeEach
  void setUp() throws Exception {
    infoBasique = new InformationPersonnelle("Skywalker", "Luke");
    infoComplete =
        new InformationPersonnelle("Skywalker", "Luke", "Plante Tatooine", 20);
  }
  
  /**
   * Ne fait rien aprs les tests :  modifier au besoin.
   *
   * @throws Exception ne peut pas tre leve ici
   */
  @AfterEach
  void tearDown() throws Exception {}
  
  /**
   * Vrifie que l'on peut positionner un age de 25 ans.
   */
  @Test
  void testAge25Basique() {
    infoBasique.setAge(25);
    assertEquals(infoBasique.getAge(), 25);
  }
  
  /**
   * Vrifie qu'on ne peut pas positionner un age ngatif sur une information
   * basique.
   */
  @Test
  void testAgeNegatifBasique() {
    infoBasique.setAge(-20);
    assertTrue(infoBasique.getAge() != -20);
  }
  
  /**
   * Vrifie qu'on ne peut pas positionner un age ngatif sur une information
   * complte.
   */
  @Test
  void testAgeNegatifComplet() {
    int age = infoComplete.getAge();
    infoComplete.setAge(-20);
    assertEquals(infoComplete.getAge(), age);
  }
  
  /**
   * Vrifie qu'une adresse n'est pas null quand on cre une information
   * personnelle.
   */
  @Test
  void testAdresseNonNull() {
    assertTrue(infoBasique.getAdresse() != null);
    assertTrue(infoComplete.getAdresse() != null);
  }
  
  /**
   * Vrifie qu'on ne peut pas positionner une adresse null sur une information
   * existante.
   */
  @Test
  void testSetterAdresseNull() {
    infoComplete.setAdresse(null);
    assertTrue(infoComplete.getAdresse() != null);
  }
  
  /**
   * Vrifie que les paramtres des constructeurs sont correctement grs.
   */
  @Test
  void testConstructeur() {
    InformationPersonnelle inf =
        new InformationPersonnelle("Vador", "Dark", null, -30);
    assertEquals(inf.getNom(), "Vador");
    assertEquals(inf.getPrenom(), "Dark");
    assertTrue(inf.getAdresse() != null);
    assertTrue(inf.getAge() >= 0);
  }
  
}
