package association;

import java.util.Set;

/**
 * Gestion des membres de l'association.
 *
 * @author Eric Cariou
 */
public interface InterGestionMembres {
  /**
   * Ajoute un membre dans l'association. Ne fait rien si le membre tait dj
   * prsent dans l'association.
   *
   * @param membre le membre  rajouter
   * @return <code>true</code> si le membre a bien t ajout,
   *         <code>false</code> si le membre tait dj prsent (dans ce cas il
   *         n'est pas ajout  nouveau)
   */
  boolean ajouterMembre(InterMembre membre);
  
  /**
   * Supprime un membre de l'association.
   *
   * @param membre le membre  supprimer
   * @return <code>true</code> si le membre tait prsent et a t supprim,
   *         <code>false</code> si le membre n'tait pas dans l'association
   */
  boolean supprimerMembre(InterMembre membre);
  
  /**
   * Dsigne le prsident de l'association. Il doit tre un des membres de
   * l'association.
   *
   * @param membre le membre  dsigner comme prsident.
   * @return <code>false</code> si le membre n'tait pas dans l'association (le
   *         prsident n'est alors pas positionn), <code>true</code> si le
   *         membre a t nomm prsident
   */
  boolean designerPresident(InterMembre membre);
  
  /**
   * Renvoie l'ensemble des membres de l'association.
   *
   * @return l'ensemble des membres de l'association.
   */
  Set<InterMembre> ensembleMembres();
  
  /**
   * Renvoie le prsident de l'association.
   *
   * @return le membre prsident de l'association s'il avait t dsign sinon
   *         retourne <code>null</code>
   */
  InterMembre president();
}
