package association;

import java.time.Month;
import java.util.List;

/**
 * Gestion des vnements d'une association.
 *
 * @author Eric Cariou
 *
 */
public interface InterGestionEvenements { 

  /**
   * Cre un nouvel vnement. Plusieurs vrifications sont effectues : que les
   * dates et heures sont cohrentes et qu'il n'y a pas un chevauchement sur la
   * mme priode avec un autre vnement dans le mme lieu.
   *
   * @param nom le nom de l'vnement
   * @param lieu le lieu
   * @param jour le jour dans le mois (nombre de 0  31)
   * @param mois le mois dans l'anne
   * @param annee l'anne
   * @param heure l'heure de la journe (nombre entre 0 et 23)
   * @param minutes les minutes de l'heure (nombre entre 0 et 59)
   * @param duree la dure (en minutes)
   * @param nbParticipants le nombre maximum de participants (0 signifie un
   *        nombre quelconque)
   * @return l'vnement cr ou <code>null</code> en cas de problme
   *         (paramtres non valides)
   */
  Evenement creerEvenement(String nom, String lieu, int jour, Month mois,
      int annee, int heure, int minutes, int duree, int nbParticipants);

  /**
   * Supprime un vnement. Les membres qui taient inscrits sont
   * automatiquement dsinscrits de l'vnement supprim. Si l'vnement
   * n'existait pas, la mthode ne fait rien.
   *
   * @param evt l'vnement  supprimer.
   */
  void supprimerEvenement(Evenement evt);

  /**
   * Renvoie l'ensemble des vnements de l'association.
   *
   * @return l'ensemble des vnements
   */
  List<Evenement> ensembleEvenements();

  /**
   * Renvoie l'ensemble des vnements  venir de l'association.
   *
   * @return l'ensemble des vnements  venir
   */
  List<Evenement> ensembleEvenementAvenir();

  /**
   * Un membre est incrit  un vnement.
   *
   * @param evt l'vnement auquel s'inscrire
   * @param mbr le membre qui s'inscrit
   * @return <code>true</code> s'il n'y a pas eu de problme, <code>false</code>
   *         si l'vnement est en conflit de calendrier avec un vnement
   *         auquel est dj inscrit le membre ou si le nombre de participants
   *         maximum est dj atteint
   */
  boolean inscriptionEvenement(Evenement evt, InterMembre mbr);

  /**
   * Dsincrit un membre d'un vnement.
   *
   * @param evt l'vnement auquel se dsinscrire
   * @param mbr le membre qui se dsincrit
   * @return si le membre tait bien inscrit  l'vnement, renvoie
   *         <code>true</code> pour prciser que l'annulation est effective,
   *         sinon <code>false</code> si le membre n'tait pas inscrit 
   *         l'vnement
   */
  boolean annulerEvenement(Evenement evt, InterMembre mbr);
}
