package association;

import java.io.IOException;

/**
 * Dfinition des actions de gestion de l'association.
 *
 * @author Eric Cariou
 */
public interface InterGestionAssociation {

  /**
   * Renvoie le gestionnaire d'vnements de l'association. L'objet retourn est
   * unique. Au premier appel de la mthode, il est cr et aux appels suivants,
   * c'est la rfrence sur cet objet qui est retourne.
   *
   * @return le gestionnaire d'vnements de l'association
   */
  InterGestionEvenements gestionnaireEvenements();

  /**
   * Renvoie le gestionnaire de membres de l'association. L'objet retourn est
   * unique. Au premier appel de la mthode, il est cr et aux appels suivants,
   * c'est la rfrence sur cet objet qui est retourne.
   *
   * @return le gestionnaire de membres de l'association
   */
  InterGestionMembres gestionnaireMembre();
  
  /**
   * Enregistre dans un fichier toutes les donnes de l'association,
   * c'est--dire l'ensemble des membres et des vnments.
   *
   * @param nomFichier le fichier dans lequel enregistrer les donnes
   * @throws IOException en cas de problme d'criture dans le fichier
   */
  void sauvegarderDonnees(String nomFichier) throws IOException;

  /**
   * Charge  partir d'un fichier toutes les donnes de l'association,
   * c'est--dire un ensemble de membres et d'vnements. Si des membres et des
   * vnments avaient dj t dfinis, ils sont crass par le contenu trouv
   * dans le fichier.
   *
   * @param nomFichier le fichier  partir duquel charger les donnes
   * @throws IOException en cas de problme de lecture dans le fichier
   */
  void chargerDonnees(String nomFichier) throws IOException;
}
